/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    public static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> onFinish) {
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (!startVec.equals((Object)(endVec = context.m_45693_()))) {
            int blockZ;
            int blockY;
            double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
            double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
            double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
            double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
            double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
            double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
            int blockX = Mth.m_14107_((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.m_14205_((double)deltaX);
            int signY = Mth.m_14205_((double)deltaY);
            int signZ = Mth.m_14205_((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return onFinish.apply(context);
    }
}

