/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.trackers;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.event.MeleeAttackEvent;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ntgl")
public class MeleeTracker {
    private static final Map<Pair<InteractionHand, LivingEntity>, Tracker> TRACKER_MAP = new HashMap<Pair<InteractionHand, LivingEntity>, Tracker>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                MeleeTracker.handTick((LivingEntity)player, InteractionHand.MAIN_HAND);
                MeleeTracker.handTick((LivingEntity)player, InteractionHand.OFF_HAND);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
                for (Pair<InteractionHand, LivingEntity> key : TRACKER_MAP.keySet()) {
                    LivingEntity entity = (LivingEntity)key.getSecond();
                    if (entity instanceof Player) continue;
                    MeleeTracker.handTick(entity, InteractionHand.MAIN_HAND);
                    MeleeTracker.handTick(entity, InteractionHand.OFF_HAND);
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            TRACKER_MAP.remove(new Pair((Object)InteractionHand.MAIN_HAND, (Object)event.getEntity()));
            TRACKER_MAP.remove(new Pair((Object)InteractionHand.OFF_HAND, (Object)event.getEntity()));
        }
    }

    public static void start(WeaponData data, InteractionHand hand) {
        SyncedDataKey<LivingEntity, Boolean> dataKey = ModSyncedDataKeys.getMeleeKey(hand);
        dataKey.setValue((Entity)data.wielder, (Object)true);
        MeleeTracker.addTracker(data, hand);
    }

    private static void addTracker(WeaponData data, InteractionHand hand) {
        assert (data.weapon != null && data.wielder != null);
        SyncedDataKey<LivingEntity, Boolean> dataKey = ModSyncedDataKeys.getMeleeKey(hand);
        LivingEntity entity = data.wielder;
        Pair key = new Pair((Object)hand, (Object)entity);
        if (!TRACKER_MAP.containsKey(key)) {
            if (!(data.weapon.m_41720_() instanceof IWeapon)) {
                dataKey.setValue((Entity)entity, (Object)false);
                return;
            }
            TRACKER_MAP.put((Pair<InteractionHand, LivingEntity>)key, new Tracker(data, hand));
            PacketHandler.sendAnimation(entity, hand, AnimationType.MELEE);
        }
    }

    private static void stopMelee(LivingEntity entity, InteractionHand hand) {
        SyncedDataKey<LivingEntity, Boolean> dataKey = ModSyncedDataKeys.getMeleeKey(hand);
        TRACKER_MAP.remove(new Pair((Object)hand, (Object)entity));
        dataKey.setValue((Entity)entity, (Object)false);
    }

    private static void handTick(LivingEntity entity, InteractionHand hand) {
        Pair key = new Pair((Object)hand, (Object)entity);
        Tracker tracker = TRACKER_MAP.get(key);
        if (tracker != null) {
            if (!tracker.isSameWeapon(entity)) {
                MeleeTracker.stopMelee(entity, hand);
            }
            if (tracker.meleeTick > 0) {
                --tracker.meleeTick;
            }
            if (tracker.meleeTick == tracker.cooldown) {
                tracker.tryMeleeAttack(tracker.data);
            }
            if (tracker.meleeTick == 0) {
                MeleeTracker.stopMelee(entity, hand);
            }
        }
    }

    private static class Tracker {
        private final InteractionHand hand;
        private final ItemStack stack;
        private final int cooldown;
        private final WeaponData data;
        private int meleeTick;
        private final int attackDelay;
        private final float meleeDamage;
        private final float knockback;
        private final double attackDistance;
        private final double attackAngle;
        private final int maxTargets;

        private Tracker(WeaponData data, InteractionHand hand) {
            this.hand = hand;
            this.data = data;
            this.stack = data.weapon;
            assert (this.stack != null);
            this.cooldown = WeaponModifierHelper.getMeleeCooldown(data);
            this.attackDelay = WeaponModifierHelper.getMeleeDelay(data);
            this.meleeTick = this.attackDelay + this.cooldown;
            this.meleeDamage = WeaponModifierHelper.getMeleeDamage(data);
            this.attackDistance = WeaponModifierHelper.getMeleeDistance(data);
            this.attackAngle = WeaponModifierHelper.getMeleeAngle(data);
            this.knockback = WeaponModifierHelper.getMeleeKnockback(data);
            this.maxTargets = WeaponModifierHelper.getMeleeMaxTargets(data);
        }

        private void tryMeleeAttack(WeaponData weaponData) {
            assert (weaponData.wielder != null && weaponData.weapon != null);
            LivingEntity wielder = weaponData.wielder;
            ArrayList<TargetInfo> targets = this.getTargets(wielder);
            ArrayList<LivingEntity> targetsToAttack = new ArrayList<LivingEntity>();
            int limit = this.maxTargets > 0 ? this.maxTargets : Integer.MAX_VALUE;
            for (int i = 0; i < Math.min(limit, targets.size()); ++i) {
                LivingEntity target = targets.get((int)i).entity;
                if (target == wielder.m_20202_()) continue;
                targetsToAttack.add(target);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new MeleeAttackEvent.Pre(wielder, weaponData, this.hand, targetsToAttack)) && !targetsToAttack.isEmpty()) {
                for (LivingEntity target : targetsToAttack) {
                    if (wielder.m_20202_() == target) continue;
                    this.attackEntity(wielder, (Entity)target);
                }
                this.playAttackSound(wielder);
                this.spawnAttackEffects(wielder, targetsToAttack);
                MinecraftForge.EVENT_BUS.post((Event)new MeleeAttackEvent.Post(wielder, weaponData, this.hand, targetsToAttack));
            }
        }

        @NotNull
        private ArrayList<TargetInfo> getTargets(LivingEntity player) {
            Vec3 playerPos = player.m_20299_(1.0f);
            Vec3 lookVec = player.m_20154_().m_82541_();
            double coneAngleCos = Math.cos(Math.toRadians(this.attackAngle / 2.0));
            ArrayList<TargetInfo> visibleTargets = new ArrayList<TargetInfo>();
            AABB area = player.m_20191_().m_82400_(this.attackDistance);
            for (Entity entity : player.m_9236_().m_45933_((Entity)player, area)) {
                Vec3 closestPoint;
                double distance;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                if (!entity.m_6097_() || entity.m_7307_((Entity)player) || (distance = playerPos.m_82554_(closestPoint = this.findClosestPointOnHitbox(playerPos, lookVec, living))) > this.attackDistance || !this.isInAttackCone(playerPos, lookVec, closestPoint, coneAngleCos) || !this.isVisible(playerPos, closestPoint, player.m_9236_())) continue;
                visibleTargets.add(new TargetInfo(living, distance, closestPoint));
            }
            visibleTargets.sort(Comparator.comparingDouble(t -> t.distance));
            return visibleTargets;
        }

        private void attackEntity(LivingEntity shooter, Entity target) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                target.m_6469_(shooter.m_269291_().m_269075_(player), this.meleeDamage);
            } else {
                target.m_6469_(shooter.m_269291_().m_269333_(shooter), this.meleeDamage);
            }
            Vec3 knockbackVec = new Vec3(target.m_20185_() - shooter.m_20185_(), 0.0, target.m_20189_() - shooter.m_20189_()).m_82541_().m_82490_((double)this.knockback);
            target.m_5997_(knockbackVec.f_82479_, knockbackVec.f_82480_ + 0.2, knockbackVec.f_82481_);
            target.f_19864_ = true;
        }

        private Vec3 findClosestPointOnHitbox(Vec3 start, Vec3 direction, LivingEntity target) {
            AABB hitbox = target.m_20191_();
            Vec3 center = hitbox.m_82399_();
            Vec3 toCenter = center.m_82546_(start);
            double projectionLength = toCenter.m_82526_(direction);
            Vec3 projectedPoint = start.m_82549_(direction.m_82490_(projectionLength));
            double x = Mth.m_14008_((double)projectedPoint.f_82479_, (double)hitbox.f_82288_, (double)hitbox.f_82291_);
            double y = Mth.m_14008_((double)projectedPoint.f_82480_, (double)hitbox.f_82289_, (double)hitbox.f_82292_);
            double z = Mth.m_14008_((double)projectedPoint.f_82481_, (double)hitbox.f_82290_, (double)hitbox.f_82293_);
            return new Vec3(x, y, z);
        }

        private boolean isSameWeapon(LivingEntity entity) {
            return !this.stack.m_41619_() && entity.m_21120_(this.hand) == this.stack;
        }

        private boolean isInAttackCone(Vec3 playerPos, Vec3 lookVec, Vec3 point, double coneAngleCos) {
            Vec3 toPoint = point.m_82546_(playerPos).m_82541_();
            return lookVec.m_82526_(toPoint) >= coneAngleCos;
        }

        private boolean isVisible(Vec3 start, Vec3 end, Level level) {
            if (level.m_5776_()) {
                return true;
            }
            ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            return level.m_45547_(context).m_6662_() == HitResult.Type.MISS;
        }

        private void playAttackSound(LivingEntity shooter) {
            shooter.m_9236_().m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 0.9f + shooter.m_217043_().m_188501_() * 0.2f);
        }

        private void spawnAttackEffects(LivingEntity player, List<LivingEntity> targets) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 lookVec = player.m_20154_().m_82490_(this.attackDistance / 2.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + lookVec.f_82479_, player.m_20186_() + 1.0, player.m_20189_() + lookVec.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                for (LivingEntity target : targets) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 5, 0.2, 0.2, 0.2, 0.1);
                }
            }
        }
    }

    private record TargetInfo(LivingEntity entity, double distance, Vec3 hitPoint) {
    }
}

