/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.tooltips.config.ClientConfig;
import dev.obscuria.tooltips.mixin.ClientTextTooltipAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public interface TooltipHelper {
    public static void enableGlowingRenderer() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
    }

    public static void disableGlowingRenderer() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static int widthOf(List<ClientTooltipComponent> components, Font font) {
        int max = 0;
        for (ClientTooltipComponent component : components) {
            int width = component.m_142069_(font);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    public static int heightOf(List<ClientTooltipComponent> components) {
        int sum = 0;
        for (ClientTooltipComponent component : components) {
            sum += component.m_142103_();
        }
        return sum;
    }

    public static List<ClientTooltipComponent> wrapLines(GuiGraphics graphics, List<ClientTooltipComponent> components, Font font) {
        int maxWidth = (int)((double)graphics.m_280182_() * 0.5);
        if (!TooltipHelper.shouldWrap(components, font, maxWidth)) {
            return components;
        }
        ArrayList<ClientTooltipComponent> result = new ArrayList<ClientTooltipComponent>(components.size() * 2);
        for (ClientTooltipComponent component : components) {
            if (!(component instanceof ClientTextTooltip)) {
                result.add(component);
                continue;
            }
            ClientTextTooltip tooltip = (ClientTextTooltip)component;
            if (tooltip.m_142069_(font) <= maxWidth) {
                result.add((ClientTooltipComponent)tooltip);
                continue;
            }
            for (FormattedText line : font.m_92865_().m_92414_(TooltipHelper.textOf(tooltip), maxWidth, Style.f_131099_)) {
                result.add((ClientTooltipComponent)new ClientTextTooltip(Language.m_128107_().m_5536_(line)));
            }
        }
        return result;
    }

    private static boolean shouldWrap(List<ClientTooltipComponent> components, Font font, int maxWidth) {
        if (!((Boolean)ClientConfig.AUTO_WRAP_ENABLED.get()).booleanValue()) {
            return false;
        }
        for (ClientTooltipComponent component : components) {
            ClientTextTooltip tooltip;
            if (!(component instanceof ClientTextTooltip) || (tooltip = (ClientTextTooltip)component).m_142069_(font) <= maxWidth) continue;
            return true;
        }
        return false;
    }

    private static FormattedText textOf(ClientTextTooltip tooltip) {
        FormattedCharSequence sequence = ((ClientTextTooltipAccessor)tooltip).getText();
        ArrayList<String> elements = new ArrayList<String>();
        ArrayList<Style> styles = new ArrayList<Style>();
        StringBuilder builder = new StringBuilder();
        AtomicReference<Style> currentStyle = new AtomicReference<Style>(Style.f_131099_);
        sequence.m_13731_((i, style, codePoint) -> {
            if (!style.equals(currentStyle.get())) {
                if (!builder.isEmpty()) {
                    elements.add(builder.toString());
                    styles.add((Style)currentStyle.get());
                    builder.setLength(0);
                }
                currentStyle.set(style);
            }
            builder.appendCodePoint(codePoint);
            return true;
        });
        if (!builder.isEmpty()) {
            elements.add(builder.toString());
            styles.add(currentStyle.get());
        }
        return new LineComponent(elements, styles);
    }

    public record LineComponent(List<String> elements, List<Style> styles) implements FormattedText
    {
        public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> consumer) {
            for (String element : this.elements) {
                consumer.m_130809_(element);
            }
            return Optional.empty();
        }

        public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> consumer, Style base) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Style style = this.styles.get(i).m_131146_(base);
                consumer.m_7164_(style, this.elements.get(i));
            }
            return Optional.empty();
        }
    }
}

