/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.toast;

import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.fragmentum.util.color.Colors;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.fragmentum.util.easing.EasingFunction;
import dev.obscuria.tooltips.ObscureTooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public final class VibrantTooltipsHint
implements Toast {
    private static final ResourceLocation ICON_TEXTURE = ObscureTooltips.key("textures/gui/icon.png");
    private static final Component VIBRANT_TOOLTIPS = Component.m_237113_((String)"Vibrant Tooltips").m_130940_(ChatFormatting.GOLD);
    private static final EasingFunction EASING_1;
    private static final EasingFunction EASING_2;
    private static final ARGB TRANSPARENT;
    private static final ARGB WHITE;
    private final MultiLineLabel label1;
    private final MultiLineLabel label2;

    public VibrantTooltipsHint() {
        Font font = Minecraft.m_91087_().f_91062_;
        this.label1 = MultiLineLabel.m_94341_((Font)font, (FormattedText)Component.m_237110_((String)"toast.obscure_tooltips.hint_1", (Object[])new Object[]{VIBRANT_TOOLTIPS}), (int)120);
        this.label2 = MultiLineLabel.m_94341_((Font)font, (FormattedText)Component.m_237115_((String)"toast.obscure_tooltips.hint_2"), (int)120);
    }

    public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent toasts, long timer) {
        graphics.m_280218_(f_94893_, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        graphics.m_280398_(ICON_TEXTURE, 6, 6, 0, 0.0f, 0.0f, 20, 20, 20, 20);
        float progress = (float)timer / 8000.0f;
        if (progress < 0.5f) {
            float y = 16.0f - (float)this.label1.m_5770_() * 4.5f;
            ARGB color = TRANSPARENT.lerp(WHITE, EASING_1.compute(progress / 0.5f));
            this.label1.m_6516_(graphics, 30, (int)y, 9, color.decimal());
        } else {
            float y = 16.0f - (float)this.label2.m_5770_() * 4.5f;
            ARGB color = TRANSPARENT.lerp(WHITE, EASING_2.compute((progress - 0.5f) / 0.5f));
            this.label2.m_6516_(graphics, 30, (int)y, 9, color.decimal());
        }
        return timer < 8000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    static {
        TRANSPARENT = Colors.argbOf((float)0.05f, (float)1.0f, (float)1.0f, (float)1.0f);
        WHITE = Colors.argbOf((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EASING_1 = Easing.CEIL.mergeOut((EasingFunction)Easing.EASE_IN_CUBIC, 0.75f);
        EASING_2 = Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.FLOOR, 0.25f);
    }
}

