/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.block.entity.behaviour;

import com.petrolpark.contamination.GenericContamination;
import com.petrolpark.contamination.ItemContamination;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ContaminationBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ContaminationBehaviour> TYPE = new BehaviourType();
    protected ListTag contaminationTag = null;
    protected boolean updateFromTag = false;
    protected final GenericContamination contamination = new GenericContamination(this::contaminationUpdated);

    public ContaminationBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void contaminationUpdated() {
        this.contaminationTag = this.contamination.writeNBT();
        this.blockEntity.notifyUpdate();
    }

    public GenericContamination getContamination() {
        if (this.updateFromTag && this.contaminationTag != null) {
            this.contamination.readNBT(this.contaminationTag);
            this.updateFromTag = false;
        }
        return this.contamination;
    }

    public void setFromItem(ItemStack stack) {
        this.contamination.contaminateAll(ItemContamination.get(stack).streamAllContaminants());
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.contaminationTag = nbt.m_128437_("Contamination", 8);
        this.updateFromTag = true;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.contaminationTag != null) {
            nbt.m_128365_("Contamination", (Tag)this.contaminationTag);
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

