/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.dough;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.compat.create.dough.Dough;
import com.petrolpark.compat.create.dough.DoughBallItem;
import com.petrolpark.compat.create.dough.DoughCut;
import com.petrolpark.util.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class DoughBall {
    public static final float THICKNESS_AREA_SCALE = 4.0f;
    public final Dough dough;
    protected float thickness = 4.0f;
    protected byte width = 1;
    protected byte length = 1;
    protected List<CutEntry> cuts = new ArrayList<CutEntry>();
    protected int cutTiles = 0;

    public DoughBall(Dough dough, float thickness, byte width, byte length, List<CutEntry> cuts) {
        this.dough = dough;
        this.thickness = thickness;
        this.width = width;
        this.length = length;
        this.cuts = cuts;
    }

    public DoughBall(CompoundTag tag) {
        this(NBTHelper.readRegistryObject(tag, "Dough", PetrolparkRegistries.Keys.DOUGH), tag.m_128457_("Thickness"), tag.m_128445_("Width"), tag.m_128445_("Length"), NBTHelper.readCompoundList(tag.m_128437_("Cuts", 10), CutEntry::new));
    }

    public static DoughBall get(ItemStack stack) {
        if (!(stack.m_41720_() instanceof DoughBallItem)) {
            return null;
        }
        return new DoughBall(stack.m_41698_("Dough"));
    }

    public boolean hasBeenCut() {
        return this.cutTiles != 0;
    }

    public record CutEntry(DoughCut cut, byte x, byte y, Rotation rotation) {
        public CutEntry(CompoundTag tag) {
            this(NBTHelper.readRegistryObject(tag, "Shape", PetrolparkRegistries.Keys.DOUGH_CUT), tag.m_128445_("x"), tag.m_128445_("y"), NBTHelper.readEnum(tag, "Rotation", Rotation.class));
        }
    }
}

