/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentRegistry;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentType;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.init.ModSounds;
import com.tiviacz.pizzadelight.tags.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class BasinBlockEntity
extends BaseBlockEntity {
    public ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_));
    private BasinContent content = BasinContent.AIR;
    private int fermentProgress = 0;
    private final int defaultFermentTime = 1200;
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private static final String BASIN_CONTENT = "BasinContent";
    private static final String FERMENT_PROGRESS = "FermentProgress";

    public BasinBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BASIN.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.content = BasinContentRegistry.REGISTRY.fromString(compound.m_128461_(BASIN_CONTENT));
        this.fermentProgress = compound.m_128451_(FERMENT_PROGRESS);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128359_(BASIN_CONTENT, this.content.toString());
        compound.m_128405_(FERMENT_PROGRESS, this.fermentProgress);
    }

    public BasinContent getBasinContent() {
        return this.content;
    }

    public InteractionResult addMilk(Level level, @Nullable Player player, @Nullable InteractionHand hand) {
        this.content = BasinContent.MILK;
        if (player != null && !player.m_7500_() && hand != null) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        level.m_5594_(player, this.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.m_6596_();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult removeMilk(ItemStack heldStack, Level level, Player player) {
        this.content = BasinContent.AIR;
        if (!player.m_7500_()) {
            heldStack.m_41774_(1);
            if (!player.m_36356_(new ItemStack((ItemLike)Items.f_42455_))) {
                level.m_7967_((Entity)new ItemEntity(player.m_9236_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), new ItemStack((ItemLike)Items.f_42455_)));
            }
        }
        this.resetFermenting();
        level.m_5594_(player, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.m_6596_();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useFermentingItem(ItemStack heldStack, Level level, @Nullable Player player) {
        if (this.getBasinContent() == BasinContent.MILK && heldStack.m_204117_(ModTags.FERMENTING_ITEMS_TAG)) {
            level.m_5594_(player, this.m_58899_(), SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player == null || !player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            this.content = BasinContent.FERMENTING_MILK;
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult removeCheese(Level level, Player player) {
        if (this.getBasinContent() == BasinContent.CHEESE) {
            Direction direction = player.m_6350_().m_122424_();
            ItemUtils.spawnItemEntity((Level)this.m_58904_(), (ItemStack)((Block)ModBlocks.CHEESE_BLOCK.get()).m_5456_().m_7968_(), (double)((double)this.m_58899_().m_123341_() + 0.5), (double)((double)this.m_58899_().m_123342_() + 0.3), (double)((double)this.m_58899_().m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
            this.content = BasinContent.AIR;
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            level.m_5594_(player, this.m_58899_(), SoundEvents.f_12132_, SoundSource.BLOCKS, 0.8f, 0.9f + level.f_46441_.m_188501_());
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getFermentProgress() {
        return this.fermentProgress;
    }

    public int getDefaultFermentTime() {
        return this.defaultFermentTime;
    }

    public int getComparatorOutput() {
        if (this.content == BasinContent.CHEESE) {
            return 15;
        }
        return 0;
    }

    public void finishFermenting() {
        if (this.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
            this.fermentProgress = 0;
            this.content = BasinContent.CHEESE;
            this.inventory.setStackInSlot(0, ((Item)ModItems.CHEESE_BLOCK.get()).m_7968_());
        }
        this.m_6596_();
    }

    public void resetFermenting() {
        this.fermentProgress = 0;
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BasinBlockEntity blockEntity) {
        boolean save = false;
        if (blockEntity.getBasinContent() != null) {
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
                ++blockEntity.fermentProgress;
                save = true;
                if (level.f_46441_.m_188500_() < 0.005) {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_BASIN_FERMENTING.get(), SoundSource.BLOCKS, 0.8f, 0.9f + level.f_46441_.m_188501_());
                }
                if (level.f_46441_.m_188500_() < 0.05) {
                    blockEntity.createMilkParticles((float)blockEntity.getFermentProgress() / (float)blockEntity.getDefaultFermentTime());
                }
            }
            if (blockEntity.getFermentProgress() >= blockEntity.getDefaultFermentTime()) {
                blockEntity.finishFermenting();
            }
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.CHEESE && level.f_46441_.m_188500_() < 0.05) {
                blockEntity.createCheeseParticle();
            }
        }
        if (save) {
            blockEntity.m_6596_();
        }
    }

    private void createMilkParticles(float fermentProgress) {
        float[] milkColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] cheeseColor = new float[]{0.91f, 0.76f, 0.31f};
        float[] currentColor = new float[3];
        for (int i = 0; i < 3; ++i) {
            currentColor[i] = (1.0f - fermentProgress) * milkColor[i] + fermentProgress * cheeseColor[i];
        }
        double x = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        double z = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(currentColor[0], currentColor[1], currentColor[2]), 1.0f), (double)this.m_58899_().m_123341_() + x + 0.2, (double)this.m_58899_().m_123342_() + 0.6, (double)this.m_58899_().m_123343_() + z + 0.2, 0.0, 0.09, 0.0);
    }

    private void createCheeseParticle() {
        double x = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        double z = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.91f, 0.76f, 0.31f), 1.0f), (double)this.m_58899_().m_123341_() + x + 0.2, (double)this.m_58899_().m_123342_() + 0.6, (double)this.m_58899_().m_123343_() + z + 0.2, 0.0, 0.09, 0.0);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> contents) {
        return new ItemStackHandler(contents){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            protected void onContentsChanged(int slot) {
                if (this.getStackInSlot(slot).m_41619_()) {
                    BasinBlockEntity.this.content = BasinContent.AIR;
                }
                BasinBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
    }
}

