/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.blocks.AbstractPizzaBlock;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.items.PizzaPeelItem;
import com.tiviacz.pizzadelight.util.TextUtils;
import com.tiviacz.pizzadelight.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class PizzaBlock
extends AbstractPizzaBlock {
    public static final IntegerProperty SLICES = IntegerProperty.m_61631_((String)"slices", (int)0, (int)3);

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SLICES, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getPizzaSliceItem() {
        return new ItemStack((ItemLike)ModItems.PIZZA_SLICE.get());
    }

    public ItemStack getPizzaSliceItem(@Nonnull Level level, @Nonnull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            ItemStack stack = this.getPizzaSliceItem();
            blockEntity2.getSlice(stack);
            return stack;
        }
        return this.getPizzaSliceItem();
    }

    public int getMaxSlices() {
        return 4;
    }

    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        pPlayer.m_6469_(pPlayer.m_269291_().m_269549_(), 1.0f);
        return super.m_5880_(pState, pPlayer, pLevel, pPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(handIn);
        if (!heldStack.m_41619_()) {
            return heldStack.m_204117_(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player.m_6350_().m_122424_()) : (heldStack.m_41720_() instanceof PizzaPeelItem && (Integer)state.m_61143_((Property)SLICES) == 0 ? this.pickUpPizza(level, pos, state, player.m_6350_().m_122424_()) : InteractionResult.PASS);
        }
        if (level.f_46443_) {
            if (this.consumeSlice(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeSlice(level, pos, state, player);
    }

    protected InteractionResult consumeSlice(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int slices;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPizzaSliceItem(level, pos);
        FoodProperties sliceFood = sliceStack.m_41720_().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.m_36324_().eat(sliceStack.m_41720_(), sliceStack, (LivingEntity)playerIn);
            for (Pair effect : sliceFood.m_38749_()) {
                if (level.f_46443_ || effect == null || !(level.f_46441_.m_188501_() < ((Float)effect.getSecond()).floatValue())) continue;
                playerIn.m_7292_((MobEffectInstance)effect.getFirst());
            }
        }
        if ((slices = ((Integer)state.m_61143_((Property)SLICES)).intValue()) < this.getMaxSlices() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SLICES, (Comparable)Integer.valueOf(slices + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            blockEntity2.requestModelDataUpdate();
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Direction direction) {
        int slices = (Integer)state.m_61143_((Property)SLICES);
        ItemStack pizzaSlice = this.getPizzaSliceItem(level, pos);
        if (slices < this.getMaxSlices() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SLICES, (Comparable)Integer.valueOf(slices + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            blockEntity2.requestModelDataUpdate();
        }
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)pizzaSlice, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLICES});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, null);
        PizzaBlock.addInformationForPizza(stack, tooltip, foodProperties != null && !foodProperties.m_38749_().isEmpty());
    }

    public static void addInformationForPizza(ItemStack stack, List<Component> tooltip, boolean addEffects) {
        if (addEffects) {
            TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
        }
        if (!Utils.isShiftPressed()) {
            tooltip.add((Component)Component.m_237115_((String)"information.pizzadelight.view_ingredients"));
        }
    }
}

