/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import com.tiviacz.pizzadelight.client.LayerSelector;
import com.tiviacz.pizzadelight.init.PizzaLayers;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.IItemHandler;
import org.joml.Vector3f;

public class PizzaBakedModel
implements IDynamicBakedModel {
    private final BakedModel baseModel;
    private final FaceBakery faceBakery = new FaceBakery();
    public static ModelProperty<Optional<IItemHandler>> LAYER_PROVIDERS = new ModelProperty();
    public static ModelProperty<Optional<Integer>> INTEGER_PROPERTY = new ModelProperty();
    public static ModelProperty<Optional<Boolean>> IS_RAW = new ModelProperty();
    protected static final float[][][] ADDITIONAL_VECTORS_SQUARE = new float[][][]{new float[][]{{1.0f, 1.0f, 1.0f}}, new float[][]{{8.0f, 1.0f, 8.0f}}};
    protected static final float[][][] ADDITIONAL_UV_SQUARE = new float[][][]{new float[][]{{1.0f, 1.0f, 8.0f, 8.0f}}, new float[][]{{8.0f, 8.0f, 15.0f, 15.0f}}, new float[][]{{8.0f, 8.0f, 15.0f, 15.0f}}, new float[][]{{1.0f, 1.0f, 8.0f, 8.0f}}};
    protected static final float[][][] VECTORS_SQUARE = new float[][][]{new float[][]{{1.0f, 1.0f, 1.0f}, {8.0f, 1.0f, 1.0f}, {8.0f, 1.0f, 1.0f}, {8.0f, 1.0f, 8.0f}}, new float[][]{{15.0f, 1.0f, 15.0f}, {15.0f, 1.0f, 15.0f}, {15.0f, 1.0f, 15.0f}, {15.0f, 1.0f, 15.0f}}};
    protected static final float[][][] UV_SQUARE = new float[][][]{new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {8.0f, 1.0f, 15.0f, 15.0f}, {8.0f, 1.0f, 15.0f, 15.0f}, {8.0f, 8.0f, 15.0f, 15.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 1.0f, 15.0f, 8.0f}, {1.0f, 1.0f, 15.0f, 8.0f}, {1.0f, 1.0f, 8.0f, 8.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 1.0f, 8.0f, 15.0f}, {1.0f, 1.0f, 8.0f, 15.0f}, {1.0f, 1.0f, 8.0f, 8.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 8.0f, 15.0f, 15.0f}, {1.0f, 8.0f, 15.0f, 15.0f}, {8.0f, 8.0f, 15.0f, 15.0f}}};

    public PizzaBakedModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public static ModelData getEmptyModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(LAYER_PROVIDERS, Optional.empty());
        builder.with(INTEGER_PROPERTY, Optional.empty());
        builder.with(IS_RAW, Optional.empty());
        ModelData modelData = builder.build();
        return modelData;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData blockEntityData) {
        return blockEntityData;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        return this.getBakedQuadsFromIModelData(state, side, rand, extraData, renderType);
    }

    private List<BakedQuad> getBakedQuadsFromIModelData(@Nullable BlockState state, Direction side, @Nonnull RandomSource rand, @Nonnull ModelData data, @Nullable RenderType renderType) {
        if (!(data.has(LAYER_PROVIDERS) && data.has(INTEGER_PROPERTY) && data.has(IS_RAW))) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        Optional layerProviders = (Optional)data.get(LAYER_PROVIDERS);
        Optional integerProperty = (Optional)data.get(INTEGER_PROPERTY);
        Optional isRaw = (Optional)data.get(IS_RAW);
        if (!(layerProviders.isPresent() && integerProperty.isPresent() && isRaw.isPresent())) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        List<BakedQuad> layerQuads = this.getLayerQuads((IItemHandler)layerProviders.get(), (Integer)integerProperty.get(), (Boolean)isRaw.get(), rand);
        LinkedList<BakedQuad> ret = new LinkedList<BakedQuad>();
        ret.addAll(this.baseModel.getQuads(state, side, rand, data, renderType));
        ret.addAll(layerQuads);
        return ret;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    private List<BakedQuad> getLayerQuads(IItemHandler inventory, int integerProperty, boolean isRaw, RandomSource randomSource) {
        int i;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ArrayList<TagKey> stack = new ArrayList<TagKey>();
        LayerSelector selector = new LayerSelector(false);
        int rotation = 0;
        for (int i2 = 0; i2 < inventory.getSlots(); ++i2) {
            stack.add(null);
        }
        List tintIndexes = this.initializeNullList(10);
        for (int i3 = 0; i3 < inventory.getSlots(); ++i3) {
            if (inventory.getStackInSlot(i3).m_41619_()) continue;
            for (int j = 0; j < i3; ++j) {
                if (inventory.getStackInSlot(j).m_41720_() != inventory.getStackInSlot(i3).m_41720_()) continue;
                rotation += 90;
            }
            ResourceLocation layerLocation = null;
            List tags = inventory.getStackInSlot(i3).m_204131_().toList();
            for (TagKey tag : tags) {
                if (!PizzaLayers.VALID_TAGS.contains(tag)) continue;
                layerLocation = isRaw ? PizzaLayers.getTagToRawLayer().get(tag) : PizzaLayers.getTagToLayer().get(tag);
                stack.set(i3, tag);
                tintIndexes.set(i3, -1);
            }
            if (layerLocation != null) continue;
            stack.set(i3, null);
            tintIndexes.set(i3, i3);
        }
        ArrayList<ResourceLocation> layers = new ArrayList<ResourceLocation>(stack.size());
        for (i = 0; i < stack.size(); ++i) {
            TagKey tagKey = (TagKey)stack.get(i);
            if (tagKey != null) {
                selector.processLayer((TagKey<Item>)tagKey);
                layers.add(i, isRaw ? PizzaLayers.getTagToRawLayer().get(tagKey) : PizzaLayers.getTagToLayer().get(tagKey));
                continue;
            }
            layers.add(i, null);
        }
        for (i = 0; i < layers.size(); ++i) {
            if (layers.get(i) != null || inventory.getStackInSlot(i).m_41619_()) continue;
            layers.set(i, selector.selectLayer());
        }
        for (i = 0; i < layers.size(); ++i) {
            if (layers.get(i) == null) continue;
            builder.add((Object)this.getQuadForLayer((ResourceLocation)layers.get(i), Direction.UP, rotation, UV_SQUARE[rotation / 90 % 4][integerProperty], VECTORS_SQUARE[0][integerProperty][0], VECTORS_SQUARE[0][integerProperty][1], VECTORS_SQUARE[0][integerProperty][2], VECTORS_SQUARE[1][integerProperty][0], VECTORS_SQUARE[1][integerProperty][1], VECTORS_SQUARE[1][integerProperty][2], (Integer)tintIndexes.get(i)));
            if (integerProperty != 1) continue;
            builder.add((Object)this.getQuadForLayer((ResourceLocation)layers.get(i), Direction.UP, rotation, ADDITIONAL_UV_SQUARE[rotation / 90 % 4][0], ADDITIONAL_VECTORS_SQUARE[0][0][0], ADDITIONAL_VECTORS_SQUARE[0][0][1], ADDITIONAL_VECTORS_SQUARE[0][0][2], ADDITIONAL_VECTORS_SQUARE[1][0][0], ADDITIONAL_VECTORS_SQUARE[1][0][1], ADDITIONAL_VECTORS_SQUARE[1][0][2], (Integer)tintIndexes.get(i)));
        }
        return builder.build();
    }

    public List initializeNullList(int size) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    private BakedQuad getQuadForLayer(ResourceLocation layerLocation, Direction face, int rotation, float[] uvArray, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int tintIndex) {
        Vector3f from = new Vector3f((float)minX, (float)minY, (float)minZ);
        Vector3f to = new Vector3f((float)maxX, (float)maxY, (float)maxZ);
        BlockFaceUV blockFaceUV = new BlockFaceUV(uvArray, rotation);
        BlockElementFace blockElementFace = new BlockElementFace(face, tintIndex, "", blockFaceUV);
        TextureAtlasSprite layersTextures = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layerLocation);
        ResourceLocation DUMMY_RL = new ResourceLocation("dummy_name");
        BakedQuad bakedQuad = this.faceBakery.m_111600_(from, to, blockElementFace, layersTextures, face, (ModelState)new SimpleModelState(Transformation.m_121093_()), null, true, DUMMY_RL);
        return bakedQuad;
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }
}

