/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.gui;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.client.gui.ScreenPizzaStation;
import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.container.PizzaMenu;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPizza
extends AbstractContainerScreen<PizzaMenu>
implements MenuAccess<PizzaMenu> {
    public static final ResourceLocation SCREEN_PIZZA = new ResourceLocation("pizzadelight", "textures/gui/pizza.png");
    private final ScreenImage HUNGER_INFO = new ScreenImage(126, 40, 13, 13);
    private final PizzaBlockEntity blockEntity;
    private final CyclingSlotBackground sauceIcon = new CyclingSlotBackground(10);
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");

    public ScreenPizza(PizzaMenu menu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)menu, inv, titleIn);
        this.blockEntity = menu.blockEntity;
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 158;
        this.f_97731_ -= 6;
    }

    public void m_181908_() {
        super.m_181908_();
        this.sauceIcon.m_266287_(ScreenPizzaStation.SAUCES);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.blockEntity.m_5446_(), this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (!this.blockEntity.getInventory().getStackInSlot(9).m_41619_()) {
            // empty if block
        }
        components.add((Component)Component.m_237115_((String)"information.pizzadelight.view_recommended_ingredients"));
        return components;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.HUNGER_INFO.inButton(this, mouseX, mouseY)) {
            guiGraphics.m_280677_(this.f_96547_, this.getTooltip(), Optional.of(new IngredientsTooltip()), mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(SCREEN_PIZZA, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.sauceIcon.m_266270_(this.f_97732_, guiGraphics, partialTicks, this.f_97735_, this.f_97736_);
    }

    public static class ScreenImage {
        private final int X;
        private final int Y;
        private final int W;
        private final int H;

        public ScreenImage(int U, int V, int W, int H) {
            this.X = U;
            this.Y = V;
            this.W = W;
            this.H = H;
        }

        public boolean inButton(ScreenPizza screen, int mouseX, int mouseY) {
            return this.X <= (mouseX -= screen.getGuiLeft()) && mouseX <= this.X + this.W && this.Y <= (mouseY -= screen.getGuiTop()) && mouseY <= this.Y + this.H;
        }
    }
}

