/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentType;
import java.util.Random;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class BasinRenderer
implements BlockEntityRenderer<BasinBlockEntity> {
    private static final ResourceLocation MILK_TEX = new ResourceLocation("pizzadelight", "textures/block/milk.png");
    private static final ResourceLocation CHEESE_TEX = new ResourceLocation("pizzadelight", "textures/block/cheese.png");
    private static final ResourceLocation OLIVE_OIL_TEX = new ResourceLocation("pizzadelight", "textures/block/olive_oil.png");
    private final Random rand = new Random();
    protected ContentModel cheese;
    protected ContentModel milk;
    protected ContentModel model;

    public BasinRenderer(BlockEntityRendererProvider.Context context) {
        this.cheese = new ContentModel(context);
        this.milk = new ContentModel(context);
        this.model = new ContentModel(context);
    }

    public void render(BasinBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.rand.setSeed(42L);
        ResourceLocation tex = this.getTexture(blockEntity.getBasinContent());
        BasinContent basinContent = blockEntity.getBasinContent();
        poseStack.m_85836_();
        if (basinContent.getContentType() == BasinContentType.FERMENTING_MILK || basinContent.getContentType() == BasinContentType.MILK) {
            float progressToFloatInv = 1.0f - (float)blockEntity.getFermentProgress() / (float)blockEntity.getDefaultFermentTime();
            this.cheese.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)CHEESE_TEX)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            this.milk.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)MILK_TEX)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, progressToFloatInv);
        }
        if (basinContent.getContentType() == BasinContentType.CHEESE) {
            this.model.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)tex)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTexture(BasinContent content) {
        return switch (content.getContentType()) {
            case BasinContentType.MILK, BasinContentType.FERMENTING_MILK -> MILK_TEX;
            case BasinContentType.CHEESE -> CHEESE_TEX;
            default -> MissingTextureAtlasSprite.m_118071_();
        };
    }

    public static class ContentModel
    extends Model {
        public static final ResourceLocation CONTENT = new ResourceLocation("pizzadelight", "content");
        public static final ModelLayerLocation CONTENT_LAYER = new ModelLayerLocation(CONTENT, "main");
        private final ModelPart content;

        public ContentModel(BlockEntityRendererProvider.Context context) {
            super(RenderType::m_110446_);
            this.content = context.m_173585_().m_171103_(CONTENT_LAYER).m_171324_("main");
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.content.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }

        public static LayerDefinition createModelData() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.m_171576_().m_171599_("main", CubeListBuilder.m_171558_().m_171481_(2.0f, 1.0f, 2.0f, 12.0f, 6.0f, 12.0f), PartPose.f_171404_);
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
        }
    }
}

