/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.tooltip;

import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.util.Utils;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientIngredientsTooltip
implements ClientTooltipComponent {
    private final ArrayList<ItemStack> doughs;
    private final ArrayList<ItemStack> sauces;
    private final ArrayList<ItemStack> items;
    private int ySize = 0;

    public ClientIngredientsTooltip(IngredientsTooltip pizzaTooltip) {
        this.items = pizzaTooltip.getIngredients();
        this.doughs = pizzaTooltip.getDoughs();
        this.sauces = pizzaTooltip.getSauces();
    }

    public int m_142103_() {
        int height = 0;
        if (!Utils.isShiftPressed()) {
            return height;
        }
        return height += (int)(Math.ceil((float)this.items.size() / 9.0f) * 18.0) + (int)(Math.ceil((float)this.doughs.size() / 9.0f) * 18.0) + (int)(Math.ceil((float)this.sauces.size() / 9.0f) * 18.0);
    }

    public int m_142069_(Font pFont) {
        int width = 0;
        if (!Utils.isShiftPressed()) {
            return width;
        }
        return width += Math.min(this.items.size(), 9) * 18 + Math.min(this.items.size(), 9) * 2;
    }

    public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
    }

    public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        int i;
        int j;
        if (!Utils.isShiftPressed()) {
            return;
        }
        int yOffset = 0;
        if (!this.doughs.isEmpty()) {
            j = 0;
            for (i = 0; i < this.doughs.size(); ++i) {
                this.renderItem(this.doughs.get(i), pX + j * 2 + j * 18, pY + this.ySize, pFont, pGuiGraphics);
                if (j < 8) {
                    ++j;
                    continue;
                }
                j = 0;
                this.ySize += 18;
                yOffset += 18;
            }
        }
        if (!this.sauces.isEmpty()) {
            this.ySize += 18;
            j = 0;
            for (i = 0; i < this.sauces.size(); ++i) {
                this.renderItem(this.sauces.get(i), pX + j * 2 + j * 18, pY + this.ySize, pFont, pGuiGraphics);
                if (j < 8) {
                    ++j;
                    continue;
                }
                j = 0;
                this.ySize += 18;
                yOffset += 18;
            }
        }
        if (!this.items.isEmpty()) {
            this.ySize += 18;
            j = 0;
            for (i = 0; i < this.items.size(); ++i) {
                this.renderItem(this.items.get(i), pX + j * 2 + j * 18, pY + this.ySize, pFont, pGuiGraphics);
                if (j < 8) {
                    ++j;
                    continue;
                }
                j = 0;
                this.ySize += 18;
                yOffset += 18;
            }
        }
    }

    private void renderItem(ItemStack stack, int pX, int pY, Font pFont, GuiGraphics guiGraphics) {
        guiGraphics.m_280203_(stack, pX, pY);
        guiGraphics.m_280370_(pFont, stack, pX, pY);
    }
}

