/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.common;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class PizzaCalculator {
    protected ItemStack base;
    protected ItemStack sauce;
    protected ItemStackHandler ingredients;
    protected NonNullList<ItemStack> processedFoods = NonNullList.m_122779_();
    protected List<Pair<MobEffectInstance, Float>> effects = new ArrayList<Pair<MobEffectInstance, Float>>();
    protected int uniqueness = 0;
    protected int hunger = 4;
    protected float saturation = 0.6f;

    public PizzaCalculator(ItemStack base, ItemStack sauce, ItemStackHandler ingredients) {
        this.base = base;
        this.sauce = sauce;
        this.ingredients = ingredients;
    }

    public ItemStack getResultStackBlock(ItemStack stack) {
        this.resetStats();
        this.ingredients.setStackInSlot(9, this.sauce);
        NBTUtils.saveInventoryToStack(stack, this.ingredients);
        return stack;
    }

    public ItemStack getResultSlice(ItemStack stack) {
        this.resetStats();
        this.ingredients.setStackInSlot(9, this.sauce);
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            this.processFood(this.ingredients.getStackInSlot(i).m_255036_(1));
        }
        int allNutrition = (this.hunger + 3) / 4 * 4;
        NBTUtils.setHunger(stack, allNutrition / 4);
        NBTUtils.setSaturation(stack, this.saturation);
        if (this.getEffect() != null) {
            NBTUtils.setEffects(stack, List.of(Pair.of((Object)this.getEffect(), (Object)Float.valueOf(1.0f))));
        }
        NBTUtils.saveInventoryToStack(stack, this.ingredients);
        return stack;
    }

    @Nullable
    public MobEffectInstance getEffect() {
        int pointer = this.uniqueness - 9;
        if (pointer == 0) {
            return new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 6000);
        }
        if (pointer >= -3 && pointer < 0) {
            return new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 3600);
        }
        if (pointer >= -6 && pointer < -3) {
            return new MobEffectInstance((MobEffect)ModEffects.COMFORT.get(), 1200);
        }
        return null;
    }

    public void processFood(ItemStack stack) {
        if (stack.getFoodProperties(null) == null) {
            return;
        }
        FoodProperties food = stack.m_41720_().getFoodProperties(stack, null);
        int nutrition = food.m_38744_();
        if (stack.m_204117_(ModTags.INGREDIENTS)) {
            nutrition += 2;
            this.saturation += 0.05f;
        }
        this.hunger += nutrition;
        if (!food.m_38749_().isEmpty()) {
            List foodEffects = food.m_38749_();
            for (Pair possibleEffect : foodEffects) {
                if (this.effects.contains(possibleEffect)) continue;
                this.effects.add((Pair<MobEffectInstance, Float>)possibleEffect);
            }
        }
        if (this.processedFoods.stream().noneMatch(s -> ItemStack.m_150942_((ItemStack)s, (ItemStack)stack))) {
            ++this.uniqueness;
        }
        this.processedFoods.add((Object)stack);
    }

    public void resetStats() {
        this.uniqueness = 0;
        this.hunger = 4;
        this.saturation = 0.6f;
        this.effects.clear();
        this.processedFoods.clear();
    }
}

