/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.handlers;

import com.tiviacz.pizzadelight.client.DynamicPizzaSliceModel;
import com.tiviacz.pizzadelight.client.PizzaBakedModel;
import com.tiviacz.pizzadelight.client.renderer.BasinRenderer;
import com.tiviacz.pizzadelight.client.renderer.ChefHatModel;
import com.tiviacz.pizzadelight.client.tooltip.ClientIngredientsTooltip;
import com.tiviacz.pizzadelight.client.tooltip.ClientPizzaTooltipComponent;
import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.client.tooltip.PizzaTooltipComponent;
import com.tiviacz.pizzadelight.init.ModBlocks;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pizzadelight", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(PizzaTooltipComponent.class, ClientPizzaTooltipComponent::new);
        event.register(IngredientsTooltip.class, ClientIngredientsTooltip::new);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register("pizza_slice_loader", (IGeometryLoader)DynamicPizzaSliceModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BasinRenderer.ContentModel.CONTENT_LAYER, BasinRenderer.ContentModel::createModelData);
        event.registerLayerDefinition(ChefHatModel.CHEF_HAT, ChefHatModel::createModelData);
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        PizzaBakedModel customModel;
        BakedModel existingModel;
        ModelResourceLocation variantMRL;
        for (BlockState blockState : ((Block)ModBlocks.PIZZA.get()).m_49965_().m_61056_()) {
            variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null || existingModel instanceof PizzaBakedModel) continue;
            customModel = new PizzaBakedModel(existingModel);
            event.getModels().put(variantMRL, customModel);
        }
        for (BlockState blockState : ((Block)ModBlocks.RAW_PIZZA.get()).m_49965_().m_61056_()) {
            variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null || existingModel instanceof PizzaBakedModel) continue;
            customModel = new PizzaBakedModel(existingModel);
            event.getModels().put(variantMRL, customModel);
        }
    }
}

