/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.handlers;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.util.NBTUtils;
import com.tiviacz.pizzadelight.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="pizzadelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerBlockItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        blockColors.m_92589_((state, world, pos, tintIndex) -> {
            BlockEntity blockEntity;
            ItemStackHandler handler = new ItemStackHandler(12);
            boolean isRaw = true;
            if (world != null && (blockEntity = world.m_7702_(pos)) instanceof PizzaBlockEntity) {
                PizzaBlockEntity be = (PizzaBlockEntity)blockEntity;
                handler = be.inventory;
                isRaw = be.isRaw();
            }
            int color = RenderUtils.getDominantColor(Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(handler.getStackInSlot(tintIndex)).m_6160_(), isRaw);
            if (handler.getStackInSlot(tintIndex).m_41720_() instanceof PotionItem) {
                color = PotionUtils.m_43575_((ItemStack)handler.getStackInSlot(tintIndex));
            }
            if (handler.getStackInSlot(tintIndex).m_41619_()) {
                return 14858625;
            }
            return color;
        }, new Block[]{(Block)ModBlocks.RAW_PIZZA.get(), (Block)ModBlocks.PIZZA.get()});
        itemColors.m_92689_((stack, tintIndex) -> {
            ItemStackHandler handler = NBTUtils.createHandlerFromStack(stack, 12);
            int color = RenderUtils.getDominantColor(Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(handler.getStackInSlot(tintIndex)).m_6160_(), stack.m_41720_() == ((Block)ModBlocks.RAW_PIZZA.get()).m_5456_());
            if (handler.getStackInSlot(tintIndex).m_41720_() instanceof PotionItem) {
                color = PotionUtils.m_43575_((ItemStack)handler.getStackInSlot(tintIndex));
            }
            if (handler.getStackInSlot(tintIndex).m_41619_()) {
                return 14858625;
            }
            return color;
        }, new ItemLike[]{(ItemLike)ModBlocks.RAW_PIZZA.get(), (ItemLike)ModBlocks.PIZZA.get()});
    }
}

