/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.items;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzadelight.util.NBTUtils;
import com.tiviacz.pizzadelight.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PizzaSliceItem
extends Item {
    public PizzaSliceItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        FoodProperties foodProperties = this.getFoodProperties(stack, null);
        if (foodProperties != null && !foodProperties.m_38749_().isEmpty()) {
            TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
        }
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity livingEntity) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(NBTUtils.getHunger(stack));
        builder.m_38758_(NBTUtils.getSaturation(stack));
        for (Pair<MobEffectInstance, Float> effect : NBTUtils.getEffects(stack)) {
            builder.effect(() -> effect.getFirst(), ((Float)effect.getSecond()).floatValue());
        }
        ArrayList<ItemStack> foods = new ArrayList<ItemStack>(NBTUtils.getIngredients(stack));
        for (ItemStack food : foods) {
            FoodProperties props = food.getFoodProperties(livingEntity);
            if (props != null) {
                if (props.m_38746_()) {
                    builder.m_38757_();
                }
                for (Pair effect : props.m_38749_()) {
                    builder.effect(() -> ((Pair)effect).getFirst(), ((Float)effect.getSecond()).floatValue());
                }
            }
            if (!(food.m_41720_() instanceof PotionItem)) continue;
            for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)food)) {
                builder.effect(() -> new MobEffectInstance(mobeffectinstance), 1.0f);
            }
        }
        return builder.m_38765_().m_38767_();
    }

    public boolean m_41472_() {
        return true;
    }
}

