/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class NBTUtils {
    public static final String TAG_INVENTORY = "Inventory";
    public static final String TAG_SAUCE = "Sauce";
    public static final String TAG_UNIQUENESS = "Uniqueness";
    public static final String TAG_HUNGER = "Hunger";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_PROBABILITY = "Probability";
    public static final String TAG_EFFECTS = "Effects";

    public static ItemStackHandler createHandlerFromStack(ItemStack stack, int size) {
        ItemStackHandler handler = new ItemStackHandler(size);
        if (stack.m_41783_() != null) {
            handler.deserializeNBT(stack.m_41783_().m_128469_(TAG_INVENTORY));
        }
        return handler;
    }

    public static List<ItemStack> getIngredients(ItemStack stack) {
        ItemStackHandler handler = NBTUtils.createHandlerFromStack(stack, 10);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            list.add(handler.getStackInSlot(i));
        }
        return list;
    }

    public static void saveInventoryToStack(ItemStack stack, ItemStackHandler handler) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128365_(TAG_INVENTORY, (Tag)handler.serializeNBT());
    }

    public static void loadInventoryFromStack(ItemStack stack, ItemStackHandler handler) {
        if (stack.m_41783_() == null) {
            return;
        }
        if (stack.m_41783_().m_128441_(TAG_INVENTORY)) {
            handler.deserializeNBT(stack.m_41783_().m_128469_(TAG_INVENTORY));
        }
    }

    public static ItemStack getSauceStack(ItemStack stack) {
        ItemStackHandler handler = NBTUtils.createHandlerFromStack(stack, 10);
        return handler.getStackInSlot(9);
    }

    public static void setUniqueness(ItemStack stack, int uniqueness) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128405_(TAG_UNIQUENESS, uniqueness);
    }

    public static int getUniqueness(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null) {
            return 0;
        }
        if (compound.m_128441_(TAG_UNIQUENESS)) {
            return compound.m_128451_(TAG_UNIQUENESS);
        }
        return 0;
    }

    public static void setHunger(ItemStack stack, int hunger) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128405_(TAG_HUNGER, hunger);
    }

    public static int getHunger(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (compound == null) {
            return 0;
        }
        if (compound.m_128441_(TAG_HUNGER)) {
            return compound.m_128451_(TAG_HUNGER);
        }
        return 0;
    }

    public static void setSaturation(ItemStack stack, float saturation) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128350_(TAG_SATURATION, saturation);
    }

    public static float getSaturation(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (compound == null) {
            return 0.0f;
        }
        if (compound.m_128441_(TAG_SATURATION)) {
            return compound.m_128457_(TAG_SATURATION);
        }
        return 0.0f;
    }

    public static void setEffects(ItemStack stack, List<Pair<MobEffectInstance, Float>> effects) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128365_(TAG_EFFECTS, (Tag)NBTUtils.writeEffectsToTag(effects));
    }

    public static List<Pair<MobEffectInstance, Float>> getEffects(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (compound == null) {
            return List.of();
        }
        if (compound.m_128441_(TAG_EFFECTS)) {
            return NBTUtils.readEffectsFromTag(compound.m_128469_(TAG_EFFECTS));
        }
        return List.of();
    }

    public static CompoundTag writeEffectsToTag(List<Pair<MobEffectInstance, Float>> effects) {
        CompoundTag compound = new CompoundTag();
        if (!effects.isEmpty()) {
            int i = 0;
            for (Pair<MobEffectInstance, Float> pair : effects) {
                CompoundTag effect = new CompoundTag();
                ((MobEffectInstance)pair.getFirst()).m_19555_(effect);
                effect.m_128350_(TAG_PROBABILITY, ((Float)pair.getSecond()).floatValue());
                compound.m_128365_(String.valueOf(i), (Tag)effect);
                ++i;
            }
        }
        return compound;
    }

    public static List<Pair<MobEffectInstance, Float>> readEffectsFromTag(CompoundTag effectsNBT) {
        ArrayList<Pair<MobEffectInstance, Float>> effects = new ArrayList<Pair<MobEffectInstance, Float>>();
        if (!effectsNBT.m_128456_()) {
            for (int i = 0; i < effectsNBT.m_128440_(); ++i) {
                CompoundTag effect = effectsNBT.m_128469_(String.valueOf(i));
                if (effect.m_128456_()) continue;
                Pair effectPair = Pair.of((Object)MobEffectInstance.m_19560_((CompoundTag)effect), (Object)Float.valueOf(effect.m_128457_(TAG_PROBABILITY)));
                effects.add((Pair<MobEffectInstance, Float>)effectPair);
            }
        }
        return effects;
    }

    public static void writeToItemStack(ItemStack stack, CompoundTag compound) {
    }
}

