/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.util;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class RenderUtils {
    public static final long CONSTANT_RENDERING_LONG = 42L;

    public static double[] getPosRandomAboveBlockHorizontal(Level level, BlockPos pos) {
        double d0 = 0.5;
        double d5 = 0.5 - d0;
        double d6 = (double)pos.m_123341_() + d5 + level.f_46441_.m_188500_() * d0 * 2.0;
        double d8 = (double)pos.m_123343_() + d5 + level.f_46441_.m_188500_() * d0 * 2.0;
        return new double[]{d6, d8};
    }

    public static int getDominantColor(TextureAtlasSprite sprite, boolean isRaw) {
        int iconWidth = sprite.m_245424_().m_246492_();
        int iconHeight = sprite.m_245424_().m_245330_();
        int frameCount = (int)sprite.m_245424_().m_245638_().count();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return 0xFFFFFF;
        }
        TreeMap<Integer, Integer> counts = new TreeMap<Integer, Integer>();
        for (int f = 0; f < frameCount; ++f) {
            for (int v = 0; v < iconWidth; ++v) {
                for (int u = 0; u < iconHeight; ++u) {
                    int rgba = sprite.getPixelRGBA(f, v, u);
                    int alpha = rgba >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    counts.merge(rgba, 1, (color, count) -> count + 1);
                }
            }
        }
        int dominantColor = 0;
        int dominantSum = 0;
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= dominantSum) continue;
            dominantSum = (Integer)entry.getValue();
            dominantColor = (Integer)entry.getKey();
        }
        Color color2 = new Color(dominantColor, true);
        return isRaw ? new Color(color2.getBlue(), color2.getGreen(), color2.getRed()).brighter().brighter().brighter().brighter().brighter().getRGB() : new Color(color2.getBlue(), color2.getGreen(), color2.getRed()).brighter().getRGB();
    }
}

