/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.blocks;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.api.blocks.BlockModelType;
import com.supermartijn642.rechiseled.api.blocks.BlockSpecification;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockBuilder;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockType;
import com.supermartijn642.rechiseled.blocks.RechiseledBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledGlassBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledGlassPillarBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledPillarBlock;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RechiseledBlockBuilderImpl
implements RechiseledBlockBuilder {
    private final RechiseledRegistrationImpl registration;
    private final String identifier;
    private Supplier<BlockProperties> properties;
    private BlockSpecification specification = BlockSpecification.BASIC;
    private boolean hasRegularVariant = true;
    private boolean hasConnectingVariant = true;
    public Supplier<Block> customRegularVariant;
    public Supplier<Block> customConnectingVariant;
    public ResourceLocation recipe;
    private final Set<CreativeModeTab> itemGroups = new HashSet<CreativeModeTab>();
    public final Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    public Supplier<Block> miningTagsFromBlock;
    public String translation;
    public BlockModelType modelType;
    private boolean completed = false;

    public RechiseledBlockBuilderImpl(RechiseledRegistrationImpl registration, String identifier) {
        this.registration = registration;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public RechiseledBlockBuilderImpl properties(BlockProperties properties) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.properties = () -> properties;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl copyProperties(Supplier<Block> block) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.properties = () -> BlockProperties.copy((Block)((Block)block.get()));
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl properties(Consumer<BlockProperties> configurer) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        if (this.properties == null) {
            throw new RuntimeException("Properties cannot be null!");
        }
        Supplier<BlockProperties> oldProperties = this.properties;
        this.properties = () -> {
            BlockProperties properties = (BlockProperties)oldProperties.get();
            configurer.accept(properties);
            return properties;
        };
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl itemGroups(CreativeModeTab group, CreativeModeTab ... groups) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.itemGroups.add(group);
        this.itemGroups.addAll(Arrays.asList(groups));
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl specification(BlockSpecification specification) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.specification = specification;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl noRegularVariant() {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.hasRegularVariant = false;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl noConnectingVariant() {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.hasConnectingVariant = false;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl regularVariant(Supplier<Block> blockSupplier) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.customRegularVariant = blockSupplier;
        this.hasRegularVariant = false;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl connectingVariant(Supplier<Block> blockSupplier) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.customConnectingVariant = blockSupplier;
        this.hasConnectingVariant = false;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl recipe(ResourceLocation location) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.recipe = location;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl blockTag(String namespace, String identifier) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.tags.add(new ResourceLocation(namespace, identifier));
        return this;
    }

    @Override
    public RechiseledBlockBuilder miningTagsFrom(Supplier<Block> blockSupplier) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.miningTagsFromBlock = blockSupplier;
        return this;
    }

    @Override
    public RechiseledBlockBuilderImpl translation(String translation) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.translation = translation;
        return this;
    }

    @Override
    public RechiseledBlockBuilder model(BlockModelType modelType) {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.modelType = modelType;
        return this;
    }

    @Override
    public RechiseledBlockType build() {
        if (this.completed) {
            throw new RuntimeException("Builder has already been build!");
        }
        this.completed = true;
        RegistrationHandler handler = RegistrationHandler.get((String)this.registration.getModid());
        if (this.properties == null) {
            throw new RuntimeException("Builder for '" + this.registration.getModid() + ":" + this.identifier + "' is missing block properties!");
        }
        Holder<BlockProperties> properties = new Holder<BlockProperties>(){

            public BlockProperties get() {
                BlockProperties properties = (BlockProperties)super.get();
                if (properties == null) {
                    properties = RechiseledBlockBuilderImpl.this.properties.get();
                    this.set(properties);
                }
                return properties;
            }
        };
        Holder regularBlockHolder = new Holder();
        Holder connectingBlockHolder = new Holder();
        if (this.hasRegularVariant) {
            handler.registerBlock(this.identifier, () -> this.lambda$build$3(regularBlockHolder, (Holder)properties));
        }
        if (this.hasConnectingVariant) {
            handler.registerBlock(this.identifier + "_connecting", () -> this.lambda$build$4(connectingBlockHolder, (Holder)properties));
        }
        Holder regularItemHolder = new Holder();
        Holder connectingItemHolder = new Holder();
        ItemProperties itemProperties = ItemProperties.create();
        this.itemGroups.forEach(arg_0 -> ((ItemProperties)itemProperties).group(arg_0));
        if (this.hasRegularVariant) {
            handler.registerItem(this.identifier, () -> {
                regularItemHolder.set((Object)new BaseBlockItem((Block)regularBlockHolder.get(), itemProperties));
                return (Item)regularItemHolder.get();
            });
        }
        if (this.hasConnectingVariant) {
            handler.registerItem(this.identifier + "_connecting", () -> {
                connectingItemHolder.set((Object)new BaseBlockItem((Block)connectingBlockHolder.get(), itemProperties));
                return (Item)connectingItemHolder.get();
            });
        }
        if (CommonUtils.getEnvironmentSide().isClient() && (this.specification == BlockSpecification.GLASS || this.specification == BlockSpecification.GLASS_PILLAR)) {
            if (this.hasRegularVariant) {
                ClientRegistrationHandler.get((String)this.registration.getModid()).registerBlockModelTranslucentRenderType(() -> ((Holder)regularBlockHolder).get());
            }
            if (this.hasConnectingVariant) {
                ClientRegistrationHandler.get((String)this.registration.getModid()).registerBlockModelTranslucentRenderType(() -> ((Holder)connectingBlockHolder).get());
            }
        }
        RechiseledBlockTypeImpl blockType = new RechiseledBlockTypeImpl(new ResourceLocation(this.registration.getModid(), this.identifier), this.specification, this.hasRegularVariant, this.hasConnectingVariant, this.hasRegularVariant ? () -> ((Holder)regularBlockHolder).get() : null, this.hasConnectingVariant ? () -> ((Holder)connectingBlockHolder).get() : null, this.hasRegularVariant ? () -> ((Holder)regularItemHolder).get() : null, this.hasConnectingVariant ? () -> ((Holder)connectingItemHolder).get() : null);
        this.registration.finalizeBuilder(this, blockType);
        return blockType;
    }

    private RechiseledBlock createBlock(boolean connecting, BlockProperties properties) {
        if (this.specification == BlockSpecification.BASIC) {
            return new RechiseledBlock(connecting, properties);
        }
        if (this.specification == BlockSpecification.PILLAR) {
            return new RechiseledPillarBlock(connecting, properties);
        }
        if (this.specification == BlockSpecification.GLASS) {
            return new RechiseledGlassBlock(connecting, properties);
        }
        if (this.specification == BlockSpecification.GLASS_PILLAR) {
            return new RechiseledGlassPillarBlock(connecting, properties);
        }
        throw new IllegalStateException("Unknown specification: " + this.specification);
    }

    private /* synthetic */ Block lambda$build$4(Holder connectingBlockHolder, Holder properties) {
        connectingBlockHolder.set((Object)this.createBlock(true, (BlockProperties)properties.get()));
        return (Block)connectingBlockHolder.get();
    }

    private /* synthetic */ Block lambda$build$3(Holder regularBlockHolder, Holder properties) {
        regularBlockHolder.set((Object)this.createBlock(false, (BlockProperties)properties.get()));
        return (Block)regularBlockHolder.get();
    }
}

