/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.inventory.item;

import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.UpgradeItemValidator;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import net.minecraft.world.item.ItemStack;

public class UpgradeItemHandler
extends BaseItemHandler {
    public UpgradeItemHandler(int size, UpgradeItem.Type ... supportedUpgrades) {
        super(size);
        for (UpgradeItem.Type supportedUpgrade : supportedUpgrades) {
            this.addValidator(new UpgradeItemValidator(supportedUpgrade));
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.m_41720_() instanceof UpgradeItem) || ((UpgradeItem)slot.m_41720_()).getType() != UpgradeItem.Type.SPEED) continue;
            speed -= speedIncrease;
        }
        return speed;
    }

    public boolean hasUpgrade(UpgradeItem.Type type) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.m_41720_() instanceof UpgradeItem) || ((UpgradeItem)slot.m_41720_()).getType() != type) continue;
            return true;
        }
        return false;
    }

    public int getUpgradeCount(UpgradeItem.Type type) {
        int upgrades = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.m_41720_() instanceof UpgradeItem) || ((UpgradeItem)slot.m_41720_()).getType() != type) continue;
            ++upgrades;
        }
        return upgrades;
    }

    public int getEnergyUsage() {
        int usage = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.m_41720_() instanceof UpgradeItem)) continue;
            usage += ((UpgradeItem)slot.m_41720_()).getType().getEnergyUsage();
        }
        return usage;
    }

    public int getStackInteractCount() {
        return this.hasUpgrade(UpgradeItem.Type.STACK) ? 64 : 1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

