/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.FluidAmountScreen;
import com.refinedmods.refinedstorage.screen.ItemAmountScreen;
import com.refinedmods.refinedstorage.screen.grid.AlternativesScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class BaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("refinedstorage", "textures/icons.png");
    private static final int Z_LEVEL_QTY = 300;
    private static final Map<Class<?>, Queue<Consumer<?>>> ACTIONS = new HashMap();
    private static final Component ALTERNATIVES_TEXT = Component.m_237115_((String)"gui.refinedstorage.alternatives");
    protected final Inventory inventory;
    private final List<SideButton> sideButtons = new ArrayList<SideButton>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private int sideButtonY;

    protected BaseScreen(T containerMenu, int xSize, int ySize, Inventory inventory, Component title) {
        super(containerMenu, inventory, title);
        this.f_97726_ = xSize;
        this.f_97727_ = ySize;
        this.inventory = inventory;
    }

    public static boolean isKeyDown(KeyMapping keybinding) {
        return !keybinding.m_90862_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybinding.getKey().m_84873_()) && keybinding.getKeyConflictContext().isActive() && keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    public static <T> void executeLater(Class<T> clazz, Consumer<T> callback) {
        ACTIONS.computeIfAbsent(clazz, key -> new ArrayDeque()).add(callback);
    }

    public static void executeLater(Consumer<AbstractContainerScreen> callback) {
        BaseScreen.executeLater(AbstractContainerScreen.class, callback);
    }

    public void runActions() {
        this.runActions(((Object)((Object)this)).getClass());
        this.runActions(AbstractContainerScreen.class);
    }

    private void runActions(Class<?> clazz) {
        Queue<Consumer<?>> queue = ACTIONS.get(clazz);
        if (queue != null && !queue.isEmpty()) {
            Consumer<?> callback;
            while ((callback = queue.poll()) != null) {
                callback.accept(this);
            }
        }
    }

    public void m_7856_() {
        this.onPreInit();
        super.m_7856_();
        this.m_169413_();
        this.sideButtonY = 6;
        this.sideButtons.clear();
        this.onPostInit(this.f_97735_, this.f_97736_);
        this.runActions();
    }

    protected void m_181908_() {
        super.m_181908_();
        this.runActions();
        this.tick(this.f_97735_, this.f_97736_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float renderPartialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground(graphics, this.f_97735_, this.f_97736_, mouseX, mouseY);
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (!slot.m_6659_() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty()) continue;
            FluidRenderer.INSTANCE.render(graphics, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, stack);
            if (!((FluidFilterSlot)slot).isSizeAllowed()) continue;
            this.renderQuantity(graphics, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, API.instance().getQuantityFormatter().formatInBucketForm(stack.getAmount()), RenderSettings.INSTANCE.getSecondaryColor());
            GL11.glDisable((int)2896);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderForeground(graphics, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (!slot.m_6659_() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty() || !RenderUtils.inBounds(slot.f_40220_, slot.f_40221_, 17, 17, mouseX, mouseY)) continue;
            this.renderTooltip(graphics, mouseX, mouseY, stack.getDisplayName().getString());
        }
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        boolean valid;
        boolean bl = valid = type != ClickType.QUICK_MOVE && this.f_96541_.f_91074_.f_36096_.m_142621_().m_41619_();
        if (valid && slot instanceof FilterSlot && slot.m_6659_() && ((FilterSlot)slot).isSizeAllowed()) {
            if (!slot.m_7993_().m_41619_()) {
                if (((FilterSlot)slot).isAlternativesAllowed() && BaseScreen.m_96637_()) {
                    this.f_96541_.m_91152_((Screen)new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, slot.m_7993_(), slot.getSlotIndex()));
                } else {
                    this.f_96541_.m_91152_((Screen)new ItemAmountScreen(this, (Player)this.f_96541_.f_91074_, slot.f_40219_, slot.m_7993_(), Math.min(slot.m_6641_(), slot.m_7993_().m_41741_()), ((FilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)parent, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, slot.m_7993_(), slot.getSlotIndex()) : null));
                }
            }
        } else if (valid && slot instanceof FluidFilterSlot && slot.m_6659_() && ((FluidFilterSlot)slot).isSizeAllowed()) {
            FluidStack stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex());
            if (!stack.isEmpty()) {
                if (((FluidFilterSlot)slot).isAlternativesAllowed() && BaseScreen.m_96637_()) {
                    this.f_96541_.m_91152_((Screen)new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()));
                } else {
                    this.f_96541_.m_91152_((Screen)new FluidAmountScreen(this, (Player)this.f_96541_.f_91074_, slot.f_40219_, stack, ((FluidFilterSlot)slot).getFluidInventory().getMaxAmount(), ((FluidFilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)this, (Player)this.f_96541_.f_91074_, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()) : null));
                }
            } else {
                super.m_6597_(slot, slotId, mouseButton, type);
            }
        } else {
            super.m_6597_(slot, slotId, mouseButton, type);
        }
    }

    public CheckboxWidget addCheckBox(int x, int y, Component text, boolean checked, Consumer<Checkbox> onPress) {
        CheckboxWidget checkBox = new CheckboxWidget(x, y, text, checked, onPress);
        this.m_142416_((GuiEventListener)checkBox);
        return checkBox;
    }

    public Button addButton(int x, int y, int w, int h, Component text, boolean enabled, boolean visible, Button.OnPress onPress) {
        Button button = Button.m_253074_((Component)text, (Button.OnPress)onPress).m_252794_(x, y).m_253046_(w, h).m_253136_();
        button.f_93623_ = enabled;
        button.f_93624_ = visible;
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    public void addSideButton(SideButton button) {
        button.m_252865_(this.f_97735_ - button.m_5711_() - 2);
        button.m_253211_(this.f_97736_ + this.sideButtonY);
        this.sideButtonY += button.m_93694_() + 2;
        this.sideButtons.add(button);
        this.m_142416_((GuiEventListener)button);
    }

    public List<SideButton> getSideButtons() {
        return this.sideButtons;
    }

    public void renderItem(GuiGraphics graphics, int x, int y, ItemStack stack) {
        this.renderItem(graphics, x, y, stack, false, null, 0);
    }

    public void renderItem(GuiGraphics graphics, int x, int y, ItemStack stack, boolean overlay, @Nullable String text, int textColor) {
        try {
            graphics.m_280480_(stack, x, y);
            if (overlay) {
                graphics.m_280302_(this.f_96547_, stack, x, y, "");
            }
            if (text != null) {
                this.renderQuantity(graphics, x, y, text, textColor);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Couldn't render stack: {}", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    public void renderQuantity(GuiGraphics graphics, int x, int y, String qty, int color) {
        boolean large = this.f_96541_.m_91390_() || RS.CLIENT_CONFIG.getGrid().getLargeFont();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 300.0f);
        if (!large) {
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        }
        graphics.m_280488_(this.f_96547_, qty, (large ? 16 : 30) - this.f_96547_.m_92895_(qty), large ? 8 : 22, color);
        graphics.m_280168_().m_85849_();
    }

    public void renderString(GuiGraphics graphics, int x, int y, String message) {
        this.renderString(graphics, x, y, message, RenderSettings.INSTANCE.getPrimaryColor());
    }

    public void renderString(GuiGraphics graphics, int x, int y, String message, int color) {
        graphics.m_280056_(this.f_96547_, message, x, y, color, false);
    }

    public void renderTooltip(GuiGraphics graphics, int x, int y, String lines) {
        this.renderTooltip(graphics, ItemStack.f_41583_, x, y, lines);
    }

    public void renderTooltip(GuiGraphics graphics, @Nonnull ItemStack stack, int x, int y, String lines) {
        this.renderTooltip(graphics, stack, x, y, Arrays.stream(lines.split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
    }

    public void renderTooltip(GuiGraphics graphics, @Nonnull ItemStack stack, int x, int y, List<Component> lines) {
        graphics.renderComponentTooltip(this.f_96547_, lines, x, y, stack);
    }

    protected void onPreInit() {
    }

    public abstract void onPostInit(int var1, int var2);

    public abstract void tick(int var1, int var2);

    public abstract void renderBackground(GuiGraphics var1, int var2, int var3, int var4, int var5);

    public abstract void renderForeground(GuiGraphics var1, int var2, int var3);
}

