/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.forge.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="roadarchitect", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RoadGraphStateForgeEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadGraphStateEvents");

    private RoadGraphStateForgeEvents() {
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphState.get(world);
            DebugLog.info(LOGGER, "RoadGraphState loaded for world {}", world.m_46472_().m_135782_());
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphState state = RoadGraphState.get(world);
            state.m_77762_();
            DebugLog.info(LOGGER, "Saved RoadGraphState for world {} on unload", world.m_46472_().m_135782_());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        for (ServerLevel world : event.getServer().m_129785_()) {
            RoadGraphState state = RoadGraphState.get(world);
            state.m_77762_();
        }
        DebugLog.info(LOGGER, "Server stopping, all RoadGraphStates marked dirty", new Object[0]);
    }
}

