/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public final class NbtUtils {
    private static final String K = "k";
    private static final String V = "v";

    private NbtUtils() {
    }

    public static <E extends Enum<E>> E getEnumOrDefault(CompoundTag tag, String key, Class<E> type, E def) {
        if (!tag.m_128441_(key)) {
            return def;
        }
        String raw = tag.m_128461_(key);
        try {
            return Enum.valueOf(type, raw);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    public static ListTag toLongIntList(Map<Long, Integer> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Integer> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.m_128356_(K, e.getKey().longValue());
            elem.m_128405_(V, e.getValue().intValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongIntMap(ListTag list, Map<Long, Integer> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.m_128728_(i);
            out.put(elem.m_128454_(K), elem.m_128451_(V));
        }
    }

    public static ListTag toLongDoubleList(Map<Long, Double> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Double> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.m_128356_(K, e.getKey().longValue());
            elem.m_128347_(V, e.getValue().doubleValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongDoubleMap(ListTag list, Map<Long, Double> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.m_128728_(i);
            out.put(elem.m_128454_(K), elem.m_128459_(V));
        }
    }

    public static ListTag toLongStringList(Map<Long, String> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, String> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.m_128356_(K, e.getKey().longValue());
            elem.m_128359_(V, e.getValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongStringMap(ListTag list, Map<Long, String> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.m_128728_(i);
            out.put(elem.m_128454_(K), elem.m_128461_(V));
        }
    }
}

