/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util.cache;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;
import net.oxcodsnet.roadarchitect.util.cache.WorldCacheState;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;

public final class ChunkHeightGenerator {
    private ChunkHeightGenerator() {
    }

    public static ChunkHeightSnapshot generate(ServerLevel world, WorldCacheState state, CacheStorage storage, ChunkPos chunkPos, int chunkSide, int columnsPerChunk) {
        int localZ;
        int localX;
        ChunkGenerator generator = world.m_7726_().m_8481_();
        if (!(generator instanceof NoiseBasedChunkGenerator)) {
            return null;
        }
        NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)generator;
        RandomState noiseConfig = world.m_7726_().m_214994_();
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)noiseGenerator.m_224341_().m_203334_();
        NoiseSettings shape = settings.f_64439_().m_224530_((LevelHeightAccessor)world);
        int horizontalBlockSize = shape.m_189213_();
        int verticalBlockSize = shape.m_189212_();
        if (horizontalBlockSize <= 0 || verticalBlockSize <= 0) {
            return null;
        }
        int horizontalCellCount = Math.max(1, chunkSide / horizontalBlockSize);
        int verticalCellCount = Mth.m_14042_((int)shape.f_64508_(), (int)verticalBlockSize);
        if (verticalCellCount <= 0) {
            return null;
        }
        int[] heights = new int[columnsPerChunk];
        Arrays.fill(heights, state.minWorldY());
        boolean[] resolved = new boolean[columnsPerChunk];
        int remaining = columnsPerChunk;
        Predicate predicate = Heightmap.Types.WORLD_SURFACE_WG.m_64299_();
        BlockState defaultBlock = settings.f_64440_();
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        int minCellY = Mth.m_14042_((int)shape.f_158688_(), (int)verticalBlockSize);
        AccessibleChunkNoiseSampler sampler = new AccessibleChunkNoiseSampler(horizontalCellCount, noiseConfig, startX, startZ, shape, ChunkHeightGenerator.noBeard(), settings, ChunkHeightGenerator.createFluidSampler(settings), Blender.m_190153_());
        sampler.m_188791_();
        long startNanos = System.nanoTime();
        block5: for (int cellX = 0; cellX < horizontalCellCount; ++cellX) {
            sampler.m_188749_(cellX);
            for (int cellZ = 0; cellZ < horizontalCellCount; ++cellZ) {
                for (int cellY = verticalCellCount - 1; cellY >= 0; --cellY) {
                    sampler.m_188810_(cellY, cellZ);
                    for (int voxelY = verticalBlockSize - 1; voxelY >= 0; --voxelY) {
                        int absoluteY = (minCellY + cellY) * verticalBlockSize + voxelY;
                        double fracY = (double)voxelY / (double)verticalBlockSize;
                        sampler.m_209191_(absoluteY, fracY);
                        for (int voxelX = horizontalBlockSize - 1; voxelX >= 0; --voxelX) {
                            int globalX = startX + cellX * horizontalBlockSize + voxelX;
                            double fracX = (double)voxelX / (double)horizontalBlockSize;
                            sampler.m_209230_(globalX, fracX);
                            for (int voxelZ = horizontalBlockSize - 1; voxelZ >= 0; --voxelZ) {
                                int globalZ = startZ + cellZ * horizontalBlockSize + voxelZ;
                                double fracZ = (double)voxelZ / (double)horizontalBlockSize;
                                sampler.m_209241_(globalZ, fracZ);
                                int localX2 = globalX & chunkSide - 1;
                                int localZ2 = globalZ & chunkSide - 1;
                                int index = localZ2 * chunkSide + localX2;
                                BlockState stateAtPos = sampler.sampleBlockStateDirect();
                                if (resolved[index]) continue;
                                if (stateAtPos == null) {
                                    stateAtPos = defaultBlock;
                                }
                                if (!predicate.test(stateAtPos)) continue;
                                heights[index] = absoluteY + 1;
                                resolved[index] = true;
                                if (--remaining == 0) break block5;
                            }
                        }
                    }
                }
            }
        }
        sampler.m_209248_();
        int noiseColumns = columnsPerChunk - remaining;
        long noiseDuration = System.nanoTime() - startNanos;
        ChunkHeightGenerator.recordLoadDurationPerColumn(noiseDuration, noiseColumns);
        if (noiseColumns > 0) {
            PipelineProfiler.increment("cache.height.loads", noiseColumns);
        }
        if (remaining > 0) {
            for (int index = 0; index < columnsPerChunk; ++index) {
                if (resolved[index]) continue;
                localX = index % chunkSide;
                localZ = index / chunkSide;
                int worldX = startX + localX;
                int worldZ = startZ + localZ;
                PipelineProfiler.increment("cache.height.loads");
                try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.height.load_time");){
                    int value;
                    heights[index] = value = generator.m_214096_(worldX, worldZ, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world, noiseConfig);
                    continue;
                }
            }
        }
        int[] index = heights;
        localX = index.length;
        for (localZ = 0; localZ < localX; ++localZ) {
            int value = index[localZ];
            PipelineProfiler.recordValue("cache.height.loaded_value", value);
        }
        boolean dirty = false;
        int writeIndex = 0;
        for (localZ = 0; localZ < chunkSide; ++localZ) {
            int localX3 = 0;
            while (localX3 < chunkSide) {
                int worldX = startX + localX3;
                int worldZ = startZ + localZ;
                long columnKey = ChunkHeightGenerator.hash(worldX, worldZ);
                int value = heights[writeIndex];
                Integer previous = storage.heights().put(columnKey, value);
                if (previous == null || previous != value) {
                    dirty = true;
                }
                ++localX3;
                ++writeIndex;
            }
        }
        if (dirty) {
            storage.m_77762_();
        }
        return new ChunkHeightSnapshot(heights, chunkSide);
    }

    private static Aquifer.FluidPicker createFluidSampler(NoiseGeneratorSettings settings) {
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int seaLevel = settings.f_64444_();
        Aquifer.FluidStatus sea = new Aquifer.FluidStatus(seaLevel, settings.f_64441_());
        int cutoff = Math.min(-54, seaLevel);
        return (x, y, z) -> y < cutoff ? lava : sea;
    }

    private static void recordLoadDurationPerColumn(long totalNanos, int columns) {
        if (columns <= 0 || totalNanos <= 0L) {
            return;
        }
        long base = totalNanos / (long)columns;
        long remainder = totalNanos % (long)columns;
        for (int i = 0; i < columns; ++i) {
            long sample = base + ((long)i < remainder ? 1L : 0L);
            PipelineProfiler.recordDuration("cache.height.load_time", sample);
        }
    }

    private static DensityFunctions.BeardifierOrMarker noBeard() {
        return LazyBeardifyingHolder.INSTANCE;
    }

    private static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static final class AccessibleChunkNoiseSampler
    extends NoiseChunk {
        AccessibleChunkNoiseSampler(int horizontalCellCount, RandomState noiseConfig, int startBlockX, int startBlockZ, NoiseSettings generationShapeConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings chunkGeneratorSettings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
            super(horizontalCellCount, noiseConfig, startBlockX, startBlockZ, generationShapeConfig, beardifying, chunkGeneratorSettings, fluidLevelSampler, blender);
        }

        BlockState sampleBlockStateDirect() {
            return super.m_209247_();
        }
    }

    private static final class LazyBeardifyingHolder {
        private static final DensityFunctions.BeardifierOrMarker INSTANCE = new DensityFunctions.BeardifierOrMarker(){

            public double m_207386_(DensityFunction.FunctionContext pos) {
                return 0.0;
            }

            public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
                Arrays.fill(densities, 0.0);
            }

            public double m_207402_() {
                return 0.0;
            }

            public double m_207401_() {
                return 0.0;
            }

            public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
                return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)DensityFunctions.m_208264_((double)0.0)));
            }
        };

        private LazyBeardifyingHolder() {
        }
    }
}

