/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class LampPostDecoration
implements Decoration {
    private static final int PLACE_FLAGS = 7;
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int HEIGHT = 3;
    private final BlockState baseState;
    private final BlockState postState;
    private final BlockState lampState;
    private final Direction facing;

    public LampPostDecoration(BlockState baseState, BlockState postState, BlockState lampState) {
        this(baseState, postState, lampState, Direction.NORTH);
    }

    private LampPostDecoration(BlockState baseState, BlockState postState, BlockState lampState, Direction facing) {
        this.baseState = baseState;
        this.postState = postState;
        this.lampState = lampState;
        this.facing = facing;
    }

    public LampPostDecoration facing(Direction facing) {
        return new LampPostDecoration(this.baseState, this.postState, this.lampState, facing);
    }

    @Override
    public void place(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        this.tryPlace(world, basePos, random);
    }

    public boolean tryPlace(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        BlockPos top = this.computeTop(world, basePos);
        if (top == null) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            if (world.m_8055_(top.m_6630_(i)).m_247087_()) continue;
            return false;
        }
        BlockPos armBase = top.m_6630_(3);
        BlockPos hook = armBase.m_121945_(this.facing);
        if (!world.m_8055_(hook).m_247087_()) {
            return false;
        }
        BlockPos lantern = hook.m_7495_();
        if (!world.m_8055_(lantern).m_247087_()) {
            return false;
        }
        this.placeSupport(world, top);
        for (int i = 1; i < 3; ++i) {
            world.m_7731_(top.m_6630_(i), this.postState, 7);
        }
        BlockState armBaseState = LampPostDecoration.withFenceConnection(this.postState, this.facing);
        world.m_7731_(armBase, armBaseState, 7);
        BlockState hookState = LampPostDecoration.withFenceConnection(this.postState, this.facing.m_122424_());
        world.m_7731_(hook, hookState, 7);
        BlockState ls = this.lampState;
        if (ls.m_61138_((Property)LanternBlock.f_153459_)) {
            ls = (BlockState)ls.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true));
        }
        world.m_7731_(lantern, ls, 7);
        return true;
    }

    private static BlockState withFenceConnection(BlockState state, Direction dir) {
        EnumProperty wallProp;
        BooleanProperty fenceProp;
        switch (dir) {
            case NORTH: {
                BooleanProperty booleanProperty = BlockStateProperties.f_61368_;
                break;
            }
            case SOUTH: {
                BooleanProperty booleanProperty = BlockStateProperties.f_61370_;
                break;
            }
            case EAST: {
                BooleanProperty booleanProperty = BlockStateProperties.f_61369_;
                break;
            }
            case WEST: {
                BooleanProperty booleanProperty = BlockStateProperties.f_61371_;
                break;
            }
            default: {
                BooleanProperty booleanProperty = fenceProp = null;
            }
        }
        if (fenceProp != null && state.m_61138_((Property)fenceProp)) {
            return (BlockState)state.m_61124_((Property)fenceProp, (Comparable)Boolean.valueOf(true));
        }
        switch (dir) {
            case NORTH: {
                EnumProperty enumProperty = BlockStateProperties.f_61379_;
                break;
            }
            case SOUTH: {
                EnumProperty enumProperty = BlockStateProperties.f_61380_;
                break;
            }
            case EAST: {
                EnumProperty enumProperty = BlockStateProperties.f_61378_;
                break;
            }
            case WEST: {
                EnumProperty enumProperty = BlockStateProperties.f_61381_;
                break;
            }
            default: {
                EnumProperty enumProperty = wallProp = null;
            }
        }
        if (wallProp != null && state.m_61138_((Property)wallProp)) {
            return (BlockState)state.m_61124_((Property)wallProp, (Comparable)WallSide.LOW);
        }
        return state;
    }

    private void placeSupport(WorldGenLevel world, BlockPos top) {
        world.m_7731_(top, this.baseState, 7);
        BlockPos cur = top.m_7495_();
        for (int depth = 0; cur.m_123342_() >= world.m_141937_() && depth < 3 && !world.m_8055_(cur).m_60796_((BlockGetter)world, cur); ++depth) {
            world.m_7731_(cur, this.baseState, 7);
            cur = cur.m_7495_();
        }
    }

    private BlockPos computeTop(WorldGenLevel world, BlockPos base) {
        int bottomY = world.m_141937_();
        boolean baseSolid = world.m_8055_(base).m_60796_((BlockGetter)world, base);
        if (!baseSolid) {
            BlockPos probe = base.m_7495_();
            for (int depth = 0; probe.m_123342_() >= bottomY && depth < 3 && !world.m_8055_(probe).m_60796_((BlockGetter)world, probe); ++depth) {
                probe = probe.m_7495_();
            }
            if (!world.m_8055_(probe).m_60796_((BlockGetter)world, probe)) {
                return null;
            }
            return probe.m_7494_();
        }
        BlockPos top = base.m_7494_();
        for (int rise = 0; rise < 3 && !world.m_8055_(top).m_247087_(); ++rise) {
            top = top.m_7494_();
        }
        if (!world.m_8055_(top).m_247087_()) {
            return null;
        }
        BlockPos probe = top.m_7495_();
        for (int depth = 0; probe.m_123342_() >= bottomY && depth < 3 && !world.m_8055_(probe).m_60796_((BlockGetter)world, probe); ++depth) {
            probe = probe.m_7495_();
        }
        if (!world.m_8055_(probe).m_60796_((BlockGetter)world, probe)) {
            return null;
        }
        return top;
    }
}

