/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.model.entity;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimplyCatModel<T extends SimplyCatEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("simplycats", "cat"), "cat");
    public ModelPart body1;
    public ModelPart body2;
    public ModelPart head1;
    public ModelPart head2;
    public ModelPart tail1;
    public ModelPart tailBobbed;
    public ModelPart frontRightLegPoint;
    public ModelPart frontLeftLegPoint;
    public ModelPart backRightLegPoint;
    public ModelPart backLeftLegPoint;
    public ModelPart nose1;
    public ModelPart earLeft1;
    public ModelPart earRight1;
    public ModelPart whiskers1;
    public ModelPart nose2;
    public ModelPart earLeft2;
    public ModelPart earRight2;
    public ModelPart earLeftTuft;
    public ModelPart earRightTuft;
    public ModelPart whiskers2;
    public ModelPart faceTuftLeft;
    public ModelPart faceTuftRight;
    public ModelPart tail2;
    public ModelPart frontRightLeg;
    public ModelPart frontLeftLeg;
    public ModelPart backRightLeg;
    public ModelPart backLeftLeg;
    public boolean isBobtail;
    public boolean isLongFur;
    public float ageScale;

    public SimplyCatModel(ModelPart root) {
        this.head1 = root.m_171324_("head1");
        this.head2 = root.m_171324_("head2");
        this.body1 = root.m_171324_("body1");
        this.body2 = root.m_171324_("body2");
        this.tail1 = root.m_171324_("tail1");
        this.tailBobbed = root.m_171324_("tailBobbed");
        this.nose1 = this.head1.m_171324_("nose1");
        this.whiskers1 = this.nose1.m_171324_("whiskers1");
        this.earLeft1 = this.head1.m_171324_("earLeft1");
        this.earRight1 = this.head1.m_171324_("earRight1");
        this.nose2 = this.head2.m_171324_("nose2");
        this.whiskers2 = this.nose2.m_171324_("whiskers2");
        this.earLeft2 = this.head2.m_171324_("earLeft2");
        this.earRight2 = this.head2.m_171324_("earRight2");
        this.faceTuftLeft = this.head2.m_171324_("faceTuftLeft");
        this.faceTuftRight = this.head2.m_171324_("faceTuftRight");
        this.earLeftTuft = this.earLeft2.m_171324_("earLeftTuft");
        this.earRightTuft = this.earRight2.m_171324_("earRightTuft");
        this.frontLeftLegPoint = this.body1.m_171324_("frontLeftLegPoint");
        this.frontLeftLeg = this.frontLeftLegPoint.m_171324_("frontLeftLeg");
        this.frontRightLegPoint = this.body1.m_171324_("frontRightLegPoint");
        this.frontRightLeg = this.frontRightLegPoint.m_171324_("frontRightLeg");
        this.backLeftLegPoint = this.body1.m_171324_("backLeftLegPoint");
        this.backLeftLeg = this.backLeftLegPoint.m_171324_("backLeftLeg");
        this.backRightLegPoint = this.body1.m_171324_("backRightLegPoint");
        this.backRightLeg = this.backRightLegPoint.m_171324_("backRightLeg");
        this.tail2 = this.tail1.m_171324_("tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition head1Def = partDefinition.m_171599_("head1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -2.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-6.5f));
        PartDefinition nose1Def = head1Def.m_171599_("nose1", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171481_(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)1.01f, (float)-4.5f));
        PartDefinition whiskers1Def = nose1Def.m_171599_("whiskers1", CubeListBuilder.m_171558_().m_171514_(2, 9).m_171481_(-4.0f, -1.0f, -0.5f, 8.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-0.1f, (float)-1.2f));
        PartDefinition earLeft1Def = head1Def.m_171599_("earLeft1", CubeListBuilder.m_171558_().m_171514_(26, 9).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)1.6f, (float)-1.5f, (float)-0.8f));
        PartDefinition earRight1Def = head1Def.m_171599_("earRight1", CubeListBuilder.m_171558_().m_171514_(18, 9).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-1.6f, (float)-1.5f, (float)-0.8f));
        PartDefinition head2Def = partDefinition.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -2.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-6.5f));
        PartDefinition nose2Def = head2Def.m_171599_("nose2", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171481_(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)1.01f, (float)-4.5f));
        PartDefinition whiskers2Def = nose2Def.m_171599_("whiskers2", CubeListBuilder.m_171558_().m_171514_(2, 9).m_171481_(-4.0f, -1.0f, -0.5f, 8.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-0.1f, (float)-1.2f));
        PartDefinition earLeft2Def = head2Def.m_171599_("earLeft2", CubeListBuilder.m_171558_().m_171514_(26, 9).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)1.6f, (float)-1.5f, (float)-0.8f));
        PartDefinition earRight2Def = head2Def.m_171599_("earRight2", CubeListBuilder.m_171558_().m_171514_(18, 9).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-1.6f, (float)-1.5f, (float)-0.8f));
        PartDefinition earLeftTuftDef = earLeft2Def.m_171599_("earLeftTuft", CubeListBuilder.m_171558_().m_171514_(27, 9).m_171481_(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition earRightTuftDef = earRight2Def.m_171599_("earRightTuft", CubeListBuilder.m_171558_().m_171514_(19, 9).m_171481_(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition faceTuftLeftDef = head2Def.m_171599_("faceTuftLeft", CubeListBuilder.m_171558_().m_171514_(7, 3).m_171481_(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f), PartPose.m_171423_((float)1.9f, (float)-0.8f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.13962634f));
        PartDefinition faceTuftRightDef = head2Def.m_171599_("faceTuftRight", CubeListBuilder.m_171558_().m_171514_(7, 3).m_171506_(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, true), PartPose.m_171423_((float)-1.9f, (float)-0.8f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.13962634f));
        PartDefinition body1Def = partDefinition.m_171599_("body1", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-2.5f, -4.0f, -1.5f, 5.0f, 5.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-5.0f));
        PartDefinition body2Def = partDefinition.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-2.5f, -3.5f, -1.6f, 5.0f, 5.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-5.0f));
        PartDefinition frontLeftLegPointDef = body1Def.m_171599_("frontLeftLegPoint", CubeListBuilder.m_171558_().m_171514_(1, 11).m_171481_(-1.5f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f), PartPose.m_171419_((float)2.2f, (float)-0.5f, (float)-0.7f));
        PartDefinition frontLeftLegDef = frontLeftLegPointDef.m_171599_("frontLeftLeg", CubeListBuilder.m_171558_().m_171514_(1, 11).m_171481_(-1.5f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition frontRightLegPointDef = body1Def.m_171599_("frontRightLegPoint", CubeListBuilder.m_171558_().m_171514_(9, 11).m_171481_(-1.5f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f), PartPose.m_171419_((float)-1.2f, (float)-0.5f, (float)-0.7f));
        PartDefinition frontRightLegDef = frontRightLegPointDef.m_171599_("frontRightLeg", CubeListBuilder.m_171558_().m_171514_(9, 11).m_171481_(-1.5f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition backLeftLegPointDef = body1Def.m_171599_("backLeftLegPoint", CubeListBuilder.m_171558_().m_171514_(1, 22).m_171481_(-1.0f, -1.5f, -1.0f, 0.0f, 0.0f, 0.0f), PartPose.m_171419_((float)1.7f, (float)-0.5f, (float)11.5f));
        PartDefinition backLeftLegDef = backLeftLegPointDef.m_171599_("backLeftLeg", CubeListBuilder.m_171558_().m_171514_(1, 22).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition backRightLegPointDef = body1Def.m_171599_("backRightLegPoint", CubeListBuilder.m_171558_().m_171514_(9, 22).m_171481_(-1.0f, -1.5f, -1.0f, 0.0f, 0.0f, 0.0f), PartPose.m_171419_((float)-1.7f, (float)-0.5f, (float)11.5f));
        PartDefinition backRightLegDef = backRightLegPointDef.m_171599_("backRightLeg", CubeListBuilder.m_171558_().m_171514_(9, 22).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition tail1Def = partDefinition.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(20, 22).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.6f, (float)((float)Math.toRadians(180.0)), (float)-0.0f, (float)0.0f));
        PartDefinition tailBobbedDef = partDefinition.m_171599_("tailBobbed", CubeListBuilder.m_171558_().m_171514_(20, 22).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)7.6f, (float)((float)Math.toRadians(135.0)), (float)-0.0f, (float)0.0f));
        PartDefinition tail2Def = tail1Def.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(28, 22).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)7.8f, (float)0.0f, (float)((float)Math.toRadians(10.0)), (float)-0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer iVertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ModelPart tailType;
        ModelPart modelPart = tailType = this.isBobtail ? this.tailBobbed : this.tail1;
        if (this.f_102610_) {
            float bodyScale = this.ageScale * 0.5f + 0.5f;
            float headScale = this.ageScale * 0.375f + 0.625f;
            matrixStack.m_85836_();
            float yHeadOffset = (16.0f * (1.0f - bodyScale) + 4.0f * (1.0f - headScale)) / 16.0f;
            float zHeadOffset = 2.5f * (1.0f - bodyScale) / 16.0f;
            matrixStack.m_252880_(0.0f, yHeadOffset, zHeadOffset);
            matrixStack.m_85841_(headScale, headScale, headScale);
            this.head1.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
            float tailScale = this.ageScale * 0.65f + 0.35f;
            matrixStack.m_85836_();
            float yTailOffset = 21.5f * (1.0f - tailScale) / 16.0f;
            float zTailOffset = 0.8f * (1.0f - tailScale) / 16.0f;
            matrixStack.m_252880_(0.0f, yTailOffset, zTailOffset);
            matrixStack.m_85841_(tailScale, tailScale, tailScale);
            tailType.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 24.0f * (1.0f - bodyScale) / 16.0f, 0.0f);
            matrixStack.m_85841_(bodyScale, bodyScale, this.ageScale * 0.6f + 0.4f);
            this.body1.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        } else {
            ModelPart head = this.isLongFur ? this.head2 : this.head1;
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.01f, 1.01f, 1.01f);
            head.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
            this.body1.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (this.isLongFur) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(this.body2.f_104200_ / 16.0f, this.body2.f_104201_ / 16.0f, this.body2.f_104202_ / 16.0f);
                matrixStack.m_85841_(1.02f, 1.2f, 1.01f);
                matrixStack.m_252880_(-this.body2.f_104200_ / 16.0f, -this.body2.f_104201_ / 16.0f, -this.body2.f_104202_ / 16.0f);
                this.body2.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_252880_(tailType.f_104200_ / 16.0f, tailType.f_104201_ / 16.0f, tailType.f_104202_ / 16.0f);
                matrixStack.m_85841_(1.25f, 1.0f, 1.25f);
                matrixStack.m_252880_(-tailType.f_104200_ / 16.0f, -tailType.f_104201_ / 16.0f, -tailType.f_104202_ / 16.0f);
                tailType.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStack.m_85849_();
            } else {
                tailType.m_104306_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float netHeadPitch) {
        ModelPart head = !entity.m_6162_() && ((SimplyCatEntity)((Object)entity)).isLongFur() ? this.head2 : this.head1;
        head.f_104203_ = netHeadPitch * ((float)Math.PI / 180);
        head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        ModelPart tailType = ((SimplyCatEntity)((Object)entity)).isBobtail() ? this.tailBobbed : this.tail1;
        ModelPart head = !entity.m_6162_() && ((SimplyCatEntity)((Object)entity)).isLongFur() ? this.head2 : this.head1;
        head.f_104205_ = 0.0f;
        head.m_104227_(0.0f, 14.0f, -6.5f);
        this.body1.m_171327_(0.0f, 0.0f, 0.0f);
        this.body1.f_104201_ = 18.0f;
        if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
            this.body2.m_171327_(0.0f, 0.0f, 0.0f);
            this.body2.f_104201_ = 18.0f;
        }
        this.frontLeftLegPoint.m_171327_(0.0f, 0.0f, 0.0f);
        this.frontRightLegPoint.m_171327_(0.0f, 0.0f, 0.0f);
        this.frontRightLegPoint.f_104201_ = -0.5f;
        this.frontLeftLegPoint.f_104201_ = -0.5f;
        this.frontRightLegPoint.f_104202_ = -0.7f;
        this.backLeftLegPoint.m_171327_(0.0f, 0.0f, 0.0f);
        this.backRightLegPoint.m_171327_(0.0f, 0.0f, 0.0f);
        this.backRightLegPoint.f_104201_ = -0.5f;
        this.backLeftLegPoint.f_104201_ = -0.5f;
        this.backLeftLegPoint.f_104200_ = 1.7f;
        this.backRightLegPoint.f_104200_ = -1.7f;
        this.frontLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.frontLeftLeg.f_104205_ = 0.0f;
        this.backRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 1.5f)) * 0.5f * limbSwingAmount;
        this.frontRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.0f)) * 0.5f * limbSwingAmount;
        this.frontRightLeg.f_104205_ = 0.0f;
        this.backLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 4.5f)) * 0.5f * limbSwingAmount;
        tailType.m_104227_(0.0f, 15.0f, 7.6f);
        this.tail1.m_171327_((float)Math.toRadians(180.0), 0.0f, 0.0f);
        this.tail2.m_171327_((float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.tailBobbed.f_104203_ = (float)Math.toRadians(135.0);
        this.earLeft1.m_171327_(0.0f, 0.0f, 0.0f);
        this.earRight1.m_171327_(0.0f, 0.0f, 0.0f);
        if (((SimplyCatEntity)((Object)entity)).isAngry() || entity.m_6047_()) {
            this.earLeft1.f_104203_ = (float)Math.toRadians(67.0);
            this.earLeft1.f_104204_ = (float)Math.toRadians(-145.0);
            this.earRight1.f_104203_ = (float)Math.toRadians(67.0);
            this.earRight1.f_104204_ = (float)Math.toRadians(145.0);
        }
        if (entity.m_6047_()) {
            head.f_104201_ += 2.5f;
            this.body1.f_104201_ += 2.0f;
            if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
                this.body2.f_104201_ += 2.0f;
            }
            this.backLeftLegPoint.f_104201_ -= 2.0f;
            this.backRightLegPoint.f_104201_ -= 2.0f;
            this.frontLeftLegPoint.f_104201_ -= 2.0f;
            this.frontRightLegPoint.f_104201_ -= 2.0f;
            tailType.f_104201_ += 2.0f;
            tailType.f_104203_ = 1.0471976f;
        } else if (((SimplyCatEntity)((Object)entity)).isResting()) {
            this.body1.f_104201_ = 23.0f;
            if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
                this.body2.f_104201_ = 23.0f;
            }
            if (((SimplyCatEntity)((Object)entity)).getRestingState() == SimplyCatEntity.RestingState.RESTING) {
                head.f_104203_ = (float)Math.toRadians(12.0);
                head.f_104201_ = 19.0f;
                this.frontRightLegPoint.f_104203_ = (float)Math.toRadians(-85.0);
                this.frontLeftLegPoint.f_104203_ = (float)Math.toRadians(-85.0);
                this.backRightLegPoint.m_171327_((float)Math.toRadians(-85.0), (float)Math.toRadians(20.0), 0.0f);
                this.backLeftLegPoint.m_171327_((float)Math.toRadians(-85.0), (float)Math.toRadians(-20.0), 0.0f);
                tailType.f_104201_ = 20.0f;
                this.tail1.f_104203_ = (float)Math.toRadians(67.0);
                this.tail2.f_104203_ = (float)Math.toRadians(18.0);
            } else if (((SimplyCatEntity)((Object)entity)).getRestingState() == SimplyCatEntity.RestingState.LOAFING) {
                head.f_104203_ = (float)Math.toRadians(16.0);
                head.f_104201_ = 19.0f;
                head.f_104202_ = -4.5f;
                this.frontRightLegPoint.m_171327_((float)Math.toRadians(96.0), (float)Math.toRadians(8.0), 0.0f);
                this.frontRightLegPoint.f_104201_ = 0.0f;
                this.frontLeftLegPoint.m_171327_((float)Math.toRadians(96.0), (float)Math.toRadians(-8.0), 0.0f);
                this.frontLeftLegPoint.f_104201_ = 0.0f;
                this.backRightLegPoint.m_171327_((float)Math.toRadians(-86.0), (float)Math.toRadians(-8.0), 0.0f);
                this.backRightLegPoint.f_104200_ = -2.1f;
                this.backRightLegPoint.f_104201_ = 0.0f;
                this.backLeftLegPoint.m_171327_((float)Math.toRadians(-86.0), (float)Math.toRadians(8.0), 0.0f);
                this.backLeftLegPoint.f_104200_ = 2.1f;
                this.backLeftLegPoint.f_104201_ = 0.0f;
                tailType.f_104201_ = 20.0f;
                this.tail1.f_104203_ = (float)Math.toRadians(67.0);
                this.tail2.f_104203_ = (float)Math.toRadians(12.0);
            } else if (((SimplyCatEntity)((Object)entity)).getRestingState() == SimplyCatEntity.RestingState.LOUNGING) {
                this.body1.f_104205_ = (float)Math.toRadians(-45.0);
                if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
                    this.body2.f_104205_ = (float)Math.toRadians(-45.0);
                }
                head.m_171327_((float)Math.toRadians(18.0), (float)Math.toRadians(-8.0), (float)Math.toRadians(-8.0));
                head.f_104200_ = -3.0f;
                head.f_104201_ = 20.5f;
                this.frontRightLegPoint.m_171327_((float)Math.toRadians(-82.0), (float)Math.toRadians(-12.0), 0.0f);
                this.frontRightLegPoint.f_104202_ = 0.3f;
                this.frontLeftLegPoint.m_171327_((float)Math.toRadians(-40.0), 0.0f, (float)Math.toRadians(-24.0));
                this.backRightLegPoint.m_171327_((float)Math.toRadians(-32.0), 0.0f, (float)Math.toRadians(-50.0));
                this.backLeftLegPoint.m_171327_((float)Math.toRadians(-8.0), 0.0f, (float)Math.toRadians(-29.0));
                tailType.f_104200_ = -2.0f;
                tailType.f_104201_ = 21.0f;
                this.tail1.m_171327_((float)Math.toRadians(50.0), 0.0f, (float)Math.toRadians(-66.0));
                this.tail2.f_104203_ = (float)Math.toRadians(18.0);
            } else if (((SimplyCatEntity)((Object)entity)).getRestingState() == SimplyCatEntity.RestingState.ROLLING) {
                this.body1.f_104205_ = (float)Math.toRadians(180.0);
                this.body1.f_104201_ = 20.0f;
                if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
                    this.body2.f_104205_ = (float)Math.toRadians(180.0);
                    this.body2.f_104201_ = 20.0f;
                }
                head.m_171327_(0.0f, (float)Math.toRadians(20.0), (float)Math.toRadians(180.0));
                head.f_104201_ = 22.0f;
                this.earLeft1.m_171327_((float)Math.toRadians(86.0), (float)Math.toRadians(-56.0), 0.0f);
                this.earRight1.m_171327_((float)Math.toRadians(86.0), (float)Math.toRadians(56.0), 0.0f);
                this.frontRightLegPoint.f_104203_ = (float)Math.toRadians(-85.0);
                this.frontRightLeg.m_171327_((float)Math.toRadians(8.0), 0.0f, (float)Math.toRadians(32.0));
                this.frontLeftLegPoint.f_104203_ = (float)Math.toRadians(-85.0);
                this.frontLeftLeg.m_171327_((float)Math.toRadians(-4.0), 0.0f, (float)Math.toRadians(-5.0));
                this.backRightLegPoint.m_171327_((float)Math.toRadians(-85.0), (float)Math.toRadians(20.0), 0.0f);
                this.backRightLeg.f_104203_ = (float)Math.toRadians(4.0);
                this.backLeftLegPoint.m_171327_((float)Math.toRadians(-85.0), (float)Math.toRadians(-20.0), 0.0f);
                this.backLeftLeg.f_104203_ = (float)Math.toRadians(12.0);
                tailType.f_104201_ = 23.0f;
                this.tail1.m_171327_((float)Math.toRadians(90.0), (float)Math.toRadians(-16.0), (float)Math.toRadians(180.0));
                this.tail2.f_104205_ = (float)Math.toRadians(-12.0);
            }
        } else if (entity.m_21825_()) {
            if (this.f_102610_) {
                float tailScale = this.ageScale * 0.65f + 0.35f;
                float bodyScale = this.ageScale * 0.5f + 0.5f;
                tailType.f_104201_ += 6.5f + (24.0f * (1.0f - bodyScale) + 21.5f * (1.0f - tailScale)) / 16.0f;
            } else {
                tailType.f_104201_ = 21.5f;
            }
            head.f_104202_ = -4.5f;
            this.body1.f_104203_ = (float)Math.toRadians(-28.0);
            if (((SimplyCatEntity)((Object)entity)).isLongFur()) {
                this.body2.f_104203_ = (float)Math.toRadians(-24.3);
            }
            this.frontLeftLeg.f_104203_ = this.frontRightLeg.f_104203_ = (float)Math.toRadians(28.0);
            this.backLeftLegPoint.f_104203_ = this.backRightLegPoint.f_104203_ = (float)Math.toRadians(-62.5);
            this.backRightLeg.f_104203_ = 0.0f;
            this.backLeftLeg.f_104203_ = 0.0f;
            tailType.f_104203_ = (float)Math.toRadians(79.0);
        }
    }
}

