/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.npc;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.block.CatnipBlock;
import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SimplyCatSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    public int m_7995_(ServerLevel level, boolean spawnHostiles, boolean spawnPassives) {
        if (spawnPassives && level.m_46469_().m_46207_(GameRules.f_46134_)) {
            --this.nextTick;
            if (this.nextTick <= 0) {
                this.nextTick = 1200;
                ServerPlayer player = level.m_8890_();
                if (player != null) {
                    RandomSource random = level.f_46441_;
                    int xOffset = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
                    int zOffset = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
                    BlockPos blockPos = player.m_20183_().m_7918_(xOffset, 0, zOffset);
                    int chunkRadius = 10;
                    if (level.m_151572_(blockPos.m_123341_() - chunkRadius, blockPos.m_123343_() - chunkRadius, blockPos.m_123341_() + chunkRadius, blockPos.m_123343_() + chunkRadius)) {
                        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockPos, (EntityType)((EntityType)SimplyCats.CAT.get()))) {
                            if (level.m_8736_(blockPos, 2)) {
                                return this.spawnInVillage(level, blockPos);
                            }
                            if (level.m_215010_().m_220491_(blockPos, StructureTags.f_215887_).m_73603_()) {
                                return this.spawnOneCatWithinRadius(level, blockPos, 16);
                            }
                        }
                        if (level.m_8055_(blockPos).m_60713_((Block)SCBlocks.CATNIP_CROP.get()) && (Integer)level.m_8055_(blockPos).m_61143_((Property)CatnipBlock.AGE) == 3) {
                            int horizontalRange = 4;
                            for (int h = 0; h < horizontalRange; ++h) {
                                int x = 0;
                                while (x <= h) {
                                    int z;
                                    int n = z = x < h && x > -h ? h : 0;
                                    while (z <= h) {
                                        BlockPos blockPos2 = blockPos.m_7918_(x, 0, z);
                                        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockPos2, (EntityType)((EntityType)SimplyCats.CAT.get()))) {
                                            return this.spawnOneCatWithinRadius(level, blockPos2, 48);
                                        }
                                        z = z > 0 ? -z : 1 - z;
                                    }
                                    x = x > 0 ? -x : 1 - x;
                                }
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    private int spawnInVillage(ServerLevel level, BlockPos blockPos) {
        List list;
        int radius = 48;
        if (level.m_8904_().m_27121_(poiTypeHolder -> poiTypeHolder.m_203565_(PoiTypes.f_218060_), blockPos, radius, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (list = level.m_45976_(SimplyCatEntity.class, new AABB(blockPos).m_82377_((double)radius, 8.0, (double)radius))).size() < 3) {
            return this.spawnCat(blockPos, level);
        }
        return 0;
    }

    private int spawnOneCatWithinRadius(ServerLevel level, BlockPos blockPos, int radius) {
        List list = level.m_45976_(SimplyCatEntity.class, new AABB(blockPos).m_82377_((double)radius, 8.0, (double)radius));
        return list.isEmpty() ? this.spawnCat(blockPos, level) : 0;
    }

    private int spawnCat(BlockPos blockPos, ServerLevel level) {
        SimplyCatEntity cat = (SimplyCatEntity)((EntityType)SimplyCats.CAT.get()).m_20615_((Level)level);
        if (cat == null) {
            return 0;
        }
        cat.m_20035_(blockPos, 0.0f, 0.0f);
        cat.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockPos), MobSpawnType.NATURAL, null, null);
        level.m_47205_((Entity)cat);
        if (cat.m_217043_().m_188501_() < 0.9f || !((Boolean)SCConfig.intact_stray_spawns.get()).booleanValue()) {
            cat.setFixed(true);
        }
        if (cat.m_217043_().m_188501_() < 0.1f) {
            int age = cat.m_217043_().m_188503_(((Integer)SCConfig.kitten_mature_timer.get()).intValue());
            cat.m_146762_(-age);
            cat.setMatureTimer(age);
        }
        cat.setHomePos(blockPos);
        return 1;
    }
}

