/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.event;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.entity.npc.SimplyCatSpawner;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SCEvents {
    private static SimplyCatSpawner simplyCatSpawner;

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        simplyCatSpawner = new SimplyCatSpawner();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (simplyCatSpawner != null) {
            simplyCatSpawner.m_7995_(ServerLifecycleHooks.getCurrentServer().m_129783_(), true, true);
        }
    }

    @SubscribeEvent
    public static void joinWorldEvent(EntityJoinLevelEvent event) {
        if (event.getEntity().getClass() == Cat.class && !event.getLevel().f_46443_) {
            Cat vanillaCat = (Cat)event.getEntity();
            if (!vanillaCat.getPersistentData().m_128441_("SimplyCatsSpawn")) {
                if (vanillaCat.m_21824_() && ((Boolean)SCConfig.replace_tamed_vanilla.get()).booleanValue()) {
                    Level world = event.getLevel();
                    SimplyCatEntity simplyCatEntity = (SimplyCatEntity)((EntityType)SimplyCats.CAT.get()).m_20615_(world);
                    simplyCatEntity.m_20258_(vanillaCat.m_20240_(new CompoundTag()));
                    simplyCatEntity.m_21051_(Attributes.f_22276_).m_22100_(14.0);
                    simplyCatEntity.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                    simplyCatEntity.m_21051_(Attributes.f_22278_).m_22100_(0.7);
                    simplyCatEntity.m_21051_(Attributes.f_22281_).m_22100_(2.0);
                    simplyCatEntity.m_5634_(4.0f);
                    simplyCatEntity.setHomePos(simplyCatEntity.m_20183_());
                    simplyCatEntity.setPhenotype();
                    if (!vanillaCat.m_21824_() && !((Boolean)SCConfig.intact_stray_spawns.get()).booleanValue()) {
                        simplyCatEntity.setFixed(true);
                    }
                    if (simplyCatEntity.getSex() == Genetics.Sex.FEMALE && !simplyCatEntity.isFixed()) {
                        simplyCatEntity.setHeatCycle(false, simplyCatEntity.m_217043_().m_188503_(((Integer)SCConfig.heat_cooldown.get()).intValue()));
                    }
                    if (world instanceof ServerLevel) {
                        ((ServerLevel)world).m_143327_(Stream.of(simplyCatEntity));
                    }
                    vanillaCat.getPersistentData().m_128379_("SimplyCatsSpawn", true);
                    event.setCanceled(true);
                } else if (!vanillaCat.m_21824_() && ((Boolean)SCConfig.stop_vanilla_spawns.get()).booleanValue()) {
                    vanillaCat.getPersistentData().m_128379_("SimplyCatsSpawn", true);
                    event.setCanceled(true);
                }
            }
        } else if (event.getEntity() instanceof Creeper) {
            Creeper creeper = (Creeper)event.getEntity();
            creeper.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, SimplyCatEntity.class, 6.0f, 1.0, 1.2));
        }
    }

    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Witch) {
            Witch witch = (Witch)livingEntity;
            if (event.getNewTarget() instanceof Player && !witch.m_9236_().m_45976_(SimplyCatEntity.class, witch.m_20191_().m_82400_(16.0)).isEmpty()) {
                event.setCanceled(true);
                witch.m_6710_(null);
            }
        }
    }
}

