/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.worldgen.villages;

import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.item.SCItems;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SCVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"simplycats");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"simplycats");
    public static final RegistryObject<PoiType> ADOPTION_BOOK = POI_TYPES.register("adoption_book", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)SCBlocks.SHELTER_BOOK.get()).m_49965_().m_61056_()), 2, 1));
    public static final RegistryObject<VillagerProfession> SHELTER_WORKER = PROFESSIONS.register("shelter_worker", () -> new VillagerProfession("shelter_worker", entry -> ((PoiType)entry.m_203334_()).equals(ADOPTION_BOOK.get()), entry -> ((PoiType)entry.m_203334_()).equals(ADOPTION_BOOK.get()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12571_));

    public static void registerTrades() {
        VillagerTrades.ItemListing[] level1 = new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)SCItems.CATNIP_SEEDS.get(), 1, 8, 4, 8), new VillagerTrades.EmeraldForItems((ItemLike)SCItems.CATNIP.get(), 20, 16, 2), new VillagerTrades.ItemsForEmeralds((Item)SCItems.STERILIZE_POTION.get(), 1, 8, 4, 16)};
        VillagerTrades.ItemListing[] level2 = new VillagerTrades.ItemListing[]{new ItemsForPetTrade((ItemLike)Items.f_42526_, 3), new ItemsForPetTrade((ItemLike)Items.f_42500_, 4)};
        VillagerTrades.ItemListing[] level3 = new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)SCItems.PET_CARRIER.get(), 2, 1, 4, 16), new VillagerTrades.EmeraldForItems((ItemLike)SCItems.CATNIP_SEEDS.get(), 20, 16, 2)};
        VillagerTrades.ItemListing[] level4 = new VillagerTrades.ItemListing[]{new ItemsForPetTrade((ItemLike)Items.f_42404_, 5), new ItemsForPetTrade((ItemLike)Items.f_42619_, 6)};
        VillagerTrades.ItemListing[] level5 = new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)SCItems.LASER_POINTER.get(), 1, 1, 1, 32), new VillagerTrades.ItemsForEmeralds((Item)SCItems.TREAT_BAG.get(), 1, 1, 1, 32)};
        VillagerTrades.f_35627_.put((VillagerProfession)SHELTER_WORKER.get(), SCVillagers.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)level1, (Object)2, (Object)level2, (Object)3, (Object)level3, (Object)4, (Object)level4, (Object)5, (Object)level5)));
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static class ItemsForPetTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack petCarrierItem;
        private final Item itemCost;

        private ItemsForPetTrade(ItemLike itemCost, int setDamageValue) {
            ItemStack carrierItem = new ItemStack((ItemLike)SCItems.PET_CARRIER.get(), 1, new CompoundTag());
            carrierItem.m_41721_(setDamageValue);
            this.petCarrierItem = carrierItem;
            this.itemCost = itemCost.m_5456_();
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int j = Math.min(8 + random.m_188503_(9), 16);
            ItemStack price = new ItemStack((ItemLike)this.itemCost, j);
            return new MerchantOffer(price, this.petCarrierItem, 2, 16, 0.2f);
        }
    }
}

