/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.lib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.Objects;
import java.util.function.Supplier;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CrafterIconButton
extends IconButton {
    private Supplier<Boolean> disabled = () -> false;
    private boolean disabledState = false;
    private Component tooltip;
    private Component[] description;
    private boolean tooltipWhenDisabled = true;

    public CrafterIconButton(int x, int y, ScreenElement icon) {
        super(x, y, icon);
    }

    public CrafterIconButton withDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public CrafterIconButton withTooltip(Component tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public CrafterIconButton tooltipWhenDisabled(boolean tooltipWhenDisabled) {
        this.tooltipWhenDisabled = tooltipWhenDisabled;
        return this;
    }

    public CrafterIconButton withDescription(Component ... description) {
        this.description = description;
        return this;
    }

    public void tick() {
        if (Objects.nonNull(this.tooltip)) {
            this.getToolTip().clear();
            if (this.tooltipWhenDisabled || !this.disabledState) {
                this.getToolTip().add(this.tooltip);
                if (Objects.nonNull(this.description)) {
                    if (Screen.m_96638_()) {
                        for (Component component : this.description) {
                            this.getToolTip().add(component);
                        }
                    } else {
                        this.getToolTip().add(TooltipHelper.holdShift((FontHelper.Palette)FontHelper.Palette.YELLOW, (boolean)Screen.m_96638_()));
                    }
                }
            }
        }
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.disabledState = this.disabled.get();
            boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            AllGuiTextures button = this.disabledState ? AllGuiTextures.BUTTON_DOWN : (this.m_5953_(mouseX, mouseY) ? AllGuiTextures.BUTTON_HOVER : AllGuiTextures.BUTTON);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawBg(graphics, button);
            this.icon.render(graphics, this.m_252754_() + 1, this.m_252907_() + 1);
        }
    }

    protected boolean m_93680_(double pMouseX, double pMouseY) {
        return !this.disabledState && super.m_93680_(pMouseX, pMouseY);
    }
}

