/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.blocks;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import com.tatnux.crafter.lib.menu.SlotItemHandlerFactory;
import com.tatnux.crafter.modules.crafter.SmartCrafterModule;
import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterBlockEntity;
import com.tatnux.crafter.modules.crafter.blocks.inventory.CrafterInventory;
import com.tatnux.crafter.modules.crafter.blocks.slots.InfoSlot;
import com.tatnux.crafter.modules.crafter.blocks.slots.ItemValidator;
import com.tatnux.crafter.modules.crafter.blocks.slots.ResultSlot;
import com.tatnux.crafter.modules.crafter.blocks.slots.SlotValidatorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SmartCrafterMenu
extends MenuBase<SmartCrafterBlockEntity> {
    public static final int CRAFT_RESULT_SLOT = 0;
    public static final int CRAFT_SLOT_START = 1;
    public static final int CRAFT_SLOTS_SIZE = 9;
    public static final int CONTAINER_START = 10;
    public static final int CONTAINER_SIZE = 18;
    public static final int RESULT_SLOT_START = 28;
    public static final int RESULT_SLOT_SIZE = 4;
    public static final int PLAYER_SLOT_START = 32;

    public SmartCrafterMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public SmartCrafterMenu(MenuType<?> type, int id, Inventory inv, SmartCrafterBlockEntity be) {
        super(type, id, inv, (Object)be);
    }

    public static SmartCrafterMenu create(int id, Inventory inv, SmartCrafterBlockEntity be) {
        return new SmartCrafterMenu((MenuType)SmartCrafterModule.CRAFTER_MENU.get(), id, inv, be);
    }

    protected SmartCrafterBlockEntity createOnClient(FriendlyByteBuf extraData) {
        BlockPos readBlockPos = extraData.m_130135_();
        CompoundTag readNbt = extraData.m_130260_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null || readNbt == null) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_(readBlockPos);
        if (blockEntity instanceof SmartCrafterBlockEntity) {
            SmartCrafterBlockEntity smartCrafterBlockEntity = (SmartCrafterBlockEntity)blockEntity;
            smartCrafterBlockEntity.readClient(readNbt);
            return smartCrafterBlockEntity;
        }
        return null;
    }

    protected void addSlots() {
        CrafterInventory itemHandler = ((SmartCrafterBlockEntity)((Object)this.contentHolder)).inventory;
        this.m_38897_((Slot)new InfoSlot(itemHandler, 0, 222, 57));
        this.addSlots(itemHandler, SlotItemHandler::new, 1, 186, -2, 3, 3);
        this.addSlots(itemHandler, SlotValidatorHandler::new, 10, 78, 80, 2, 9);
        this.addSlots(itemHandler, ResultSlot::new, 28, 38, 80, 2, 2);
        this.addPlayerSlots(58, 167);
    }

    private void addSlots(ItemValidator itemHandler, SlotItemHandlerFactory factory, int index, int x, int y, int row, int col) {
        for (int iRow = 0; iRow < row; ++iRow) {
            for (int iCol = 0; iCol < col; ++iCol) {
                this.m_38897_((Slot)factory.on(itemHandler, index + iCol + iRow * col, x + iCol * 18, y + iRow * 18));
            }
        }
    }

    protected void initAndReadInventory(SmartCrafterBlockEntity contentHolder) {
    }

    protected void saveData(SmartCrafterBlockEntity contentHolder) {
    }

    public void m_150399_(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        ItemStack insert;
        if (slotId < 1 || slotId >= 10) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.m_142621_();
        if (clickTypeIn == ClickType.CLONE) {
            if (player.m_7500_() && held.m_41619_()) {
                ItemStack stackInSlot = ((SmartCrafterBlockEntity)((Object)this.contentHolder)).inventory.getStackInSlot(slotId).m_41777_();
                stackInSlot.m_41764_(stackInSlot.m_41741_());
                this.m_142503_(stackInSlot);
                return;
            }
            return;
        }
        if (held.m_41619_()) {
            insert = ItemStack.f_41583_;
        } else {
            insert = held.m_41777_();
            insert.m_41764_(1);
        }
        ((SmartCrafterBlockEntity)((Object)this.contentHolder)).inventory.setStackInSlot(slotId, insert);
        this.m_38853_(slotId).m_6654_();
        ((SmartCrafterBlockEntity)((Object)this.contentHolder)).updateWorkInventory();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (index < 10) {
            return itemStack;
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            itemStack = item.m_41777_();
            if (index < 32 ? !this.m_38903_(item, 32, this.f_38839_.size(), true) : !this.m_38903_(item, 10, 28, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_5622_(Slot pSlot) {
        return super.m_5622_(pSlot);
    }

    public boolean m_5882_(@NotNull ItemStack stack, Slot pSlot) {
        return pSlot.f_40218_ == this.playerInventory || pSlot.f_40219_ >= 10;
    }

    public boolean isCraftingEmpty() {
        for (int i = 0; i < 10; ++i) {
            if (this.m_38853_(i).m_7993_().m_41619_()) continue;
            return false;
        }
        return true;
    }
}

