/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class GhostSlots
implements INBTSerializable<ListTag> {
    private final Set<GhostSlotEntry> entries = new HashSet<GhostSlotEntry>();

    public void addSlot(ItemStack itemStack, byte slot) {
        this.entries.stream().filter(ghostSlotEntry -> ghostSlotEntry.getItem().equals(itemStack, false)).findFirst().orElseGet(() -> {
            GhostSlotEntry ghostSlotEntry = new GhostSlotEntry(itemStack);
            this.entries.add(ghostSlotEntry);
            return ghostSlotEntry;
        }).getSlots().add(slot);
    }

    public void clear() {
        this.entries.clear();
    }

    public ListTag serializeNBT() {
        ListTag listTag = new ListTag();
        this.entries.forEach(ghostSlotEntry -> listTag.add((Object)ghostSlotEntry.serializeNBT()));
        return listTag;
    }

    public void deserializeNBT(ListTag listTag) {
        this.entries.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            this.entries.add(new GhostSlotEntry(listTag.m_128728_(i)));
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean mayPlace(byte slot, ItemStack stack) {
        return this.entries.stream().filter(ghostSlotEntry -> ghostSlotEntry.getSlots().contains(slot)).findFirst().map(ghostSlotEntry -> ghostSlotEntry.getItem().equals(stack.m_255036_(1), false)).orElse(true);
    }

    @Generated
    public Set<GhostSlotEntry> getEntries() {
        return this.entries;
    }

    public static class GhostSlotEntry
    implements INBTSerializable<CompoundTag> {
        private ItemStack item;
        private final Set<Byte> slots = new HashSet<Byte>();

        public GhostSlotEntry(ItemStack item) {
            this.item = item;
        }

        public GhostSlotEntry(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("Item", (Tag)this.item.serializeNBT());
            compoundTag.m_128365_("Slots", (Tag)new ByteArrayTag(new ArrayList<Byte>(this.slots)));
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            this.item = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item"));
            this.slots.clear();
            for (byte b : compoundTag.m_128463_("Slots")) {
                this.slots.add(b);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GhostSlotEntry ghostSlot = (GhostSlotEntry)o;
            return Objects.equals(this.item, ghostSlot.item);
        }

        public int hashCode() {
            return Objects.hashCode(this.item);
        }

        @Generated
        public ItemStack getItem() {
            return this.item;
        }

        @Generated
        public Set<Byte> getSlots() {
            return this.slots;
        }

        @Generated
        public void setItem(ItemStack item) {
            this.item = item;
        }

        @Generated
        public String toString() {
            return "GhostSlots.GhostSlotEntry(item=" + this.getItem() + ", slots=" + this.getSlots() + ")";
        }
    }
}

