/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smithing;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smithing.SmithingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class SmithingUpgradeContainer
extends UpgradeContainerBase<SmithingUpgradeWrapper, SmithingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final Slot resultSlot;
    private Runnable onResultChanged = () -> {};
    private final PersistableSmithingMenu smithingMenuDelegate;

    public SmithingUpgradeContainer(Player player, int upgradeContainerId, SmithingUpgradeWrapper upgradeWrapper, UpgradeContainerType<SmithingUpgradeWrapper, SmithingUpgradeContainer> type) {
        super(player, upgradeContainerId, (IUpgradeWrapper)upgradeWrapper, type);
        this.smithingMenuDelegate = new PersistableSmithingMenu(new Inventory(player));
        this.slots.add(this.smithingMenuDelegate.m_38853_(0));
        this.slots.add(this.smithingMenuDelegate.m_38853_(1));
        this.slots.add(this.smithingMenuDelegate.m_38853_(2));
        this.resultSlot = this.smithingMenuDelegate.m_38853_(3);
        this.slots.add(this.resultSlot);
        this.smithingMenuDelegate.m_6640_();
    }

    public void setOnResultChangedHandler(Runnable onResultChanged) {
        this.onResultChanged = onResultChanged;
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        }
    }

    public void setUpgradeWrapper(IUpgradeWrapper updatedUpgradeWrapper) {
        super.setUpgradeWrapper(updatedUpgradeWrapper);
        this.smithingMenuDelegate.m_6640_();
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((SmithingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((SmithingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean((CompoundTag)new CompoundTag(), (String)DATA_SHIFT_CLICK_INTO_STORAGE, (boolean)shiftClickIntoStorage));
    }

    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    public boolean allowsPickupAll(Slot slot) {
        return slot != this.resultSlot;
    }

    public Slot getTemplateSlot() {
        return this.smithingMenuDelegate.m_38853_(0);
    }

    public Slot getBaseSlot() {
        return this.smithingMenuDelegate.m_38853_(1);
    }

    public Slot getAdditionalSlot() {
        return this.smithingMenuDelegate.m_38853_(2);
    }

    public Slot getResultSlot() {
        return this.smithingMenuDelegate.m_38853_(3);
    }

    public List<Slot> getRecipeSlots() {
        return List.of(this.getTemplateSlot(), this.getBaseSlot(), this.getAdditionalSlot());
    }

    public Container getCraftMatrix() {
        return this.smithingMenuDelegate.getInputSlots();
    }

    public void setRecipeUsed(ResourceLocation recipeId) {
        this.smithingMenuDelegate.setSelectedRecipe(recipeId);
    }

    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44113_;
    }

    public boolean shouldRefillCraftingGrid() {
        return false;
    }

    private class PersistableSmithingMenu
    extends SmithingMenu {
        public PersistableSmithingMenu(Inventory playerInventory) {
            super(0, playerInventory, playerInventory.f_35978_.m_9236_().m_5776_() ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)playerInventory.f_35978_.m_20183_()));
        }

        protected void m_266254_(ItemCombinerMenuSlotDefinition itemCombinerMenuSlotDefinition) {
            for (final ItemCombinerMenuSlotDefinition.SlotDefinition slotDefinition : itemCombinerMenuSlotDefinition.m_266233_()) {
                this.m_38897_((Slot)new SlotSuppliedHandler(((SmithingUpgradeWrapper)SmithingUpgradeContainer.this.upgradeWrapper)::getInventory, slotDefinition.f_266086_(), 0, 0){

                    public void m_6654_() {
                        super.m_6654_();
                        PersistableSmithingMenu.this.m_6199_(PersistableSmithingMenu.this.f_39769_);
                    }

                    public boolean m_5857_(ItemStack p_267156_) {
                        return slotDefinition.f_265897_().test(p_267156_);
                    }
                });
            }
        }

        protected SimpleContainer m_266190_(int size) {
            return new SimpleContainer(size){

                public void m_6596_() {
                    super.m_6596_();
                    PersistableSmithingMenu.this.m_6199_((Container)this);
                }

                public ItemStack m_8020_(int pIndex) {
                    return ((SmithingUpgradeWrapper)SmithingUpgradeContainer.this.upgradeWrapper).getInventory().getStackInSlot(pIndex);
                }

                public void m_6836_(int pIndex, ItemStack pStack) {
                    ((SmithingUpgradeWrapper)SmithingUpgradeContainer.this.upgradeWrapper).getInventory().setStackInSlot(pIndex, pStack);
                }
            };
        }

        protected void m_266430_(ItemCombinerMenuSlotDefinition slotDefinition) {
            this.m_38897_(new Slot((Container)this.f_39768_, slotDefinition.m_266349_().f_266086_(), slotDefinition.m_266349_().f_266065_(), slotDefinition.m_266349_().f_265926_()){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return PersistableSmithingMenu.this.m_6560_(player, this.m_6657_());
                }

                public void m_142406_(Player player, ItemStack stack) {
                    PersistableSmithingMenu.this.m_142365_(player, stack);
                }

                public void m_6654_() {
                    super.m_6654_();
                    SmithingUpgradeContainer.this.onResultChanged.run();
                }
            });
        }

        public void m_6199_(Container pInventory) {
            this.m_6640_();
            SmithingUpgradeContainer.this.onResultChanged.run();
        }

        public Container getInputSlots() {
            return this.f_39769_;
        }

        public void setSelectedRecipe(ResourceLocation recipeId) {
            RecipeHelper.safeGetRecipeFor((RecipeType)RecipeType.f_44113_, (Container)this.f_39769_, (ResourceLocation)recipeId).ifPresent(recipe -> {
                this.f_40242_ = recipe;
            });
        }
    }
}

