/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;

public class ItemFlightAnimator {
    private static final List<Flight> flights = new ArrayList<Flight>();
    private static final float START_PROGRESS = 0.12f;
    private static final double LAUNCH_PUSH = 0.25;

    public static void startFlightFromPayload(FlightPayload payload, RandomSource rng) {
        flights.add(new Flight(payload, rng));
    }

    public static void startFlight(ItemStack stack, Vec3 from, Vec3 to, long startGameTime, int durationTicks, RandomSource rng) {
        ItemFlightAnimator.startFlightFromPayload(new FlightPayload(stack.m_41777_(), from, to, startGameTime, durationTicks), rng);
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (flights.isEmpty() || mc.f_91073_ == null) {
            return;
        }
        long gameTime = mc.f_91073_.m_46467_();
        Iterator<Flight> it = flights.iterator();
        while (it.hasNext()) {
            Flight flight = it.next();
            double timeRaw = (double)((float)gameTime + partialTick - (float)flight.startTime) / (double)flight.durationTicks;
            float time = (float)Mth.m_14008_((double)timeRaw, (double)0.0, (double)1.0);
            float progress = 0.12f + 0.88f * Easing.EASE_IN_OUT_CUBIC.ease(time);
            Vec3 pos = ItemFlightAnimator.lerp(flight.from, flight.to, progress);
            double spinP = Easing.EASE_OUT_CUBIC.ease(progress);
            float spinDeg = (float)(flight.spinTurns * 360.0 * spinP);
            float scale = (float)(0.9 + 0.1 * (double)progress);
            poseStack.m_85836_();
            poseStack.m_85837_(pos.f_82479_ - cameraPos.m_7096_(), pos.f_82480_ - cameraPos.m_7098_(), pos.f_82481_ - cameraPos.m_7094_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(flight.yawDeg));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(spinDeg));
            poseStack.m_85837_(0.0, -0.15, 0.0);
            poseStack.m_85841_(scale, scale, scale);
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            mc.m_91291_().m_269128_(flight.stack, ItemDisplayContext.GROUND, LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_)), OverlayTexture.f_118083_, poseStack, (MultiBufferSource)buffer, (Level)mc.f_91073_, 0);
            poseStack.m_85849_();
            if (!((double)time >= 1.0)) continue;
            it.remove();
        }
    }

    private static Vec3 lerp(Vec3 a, Vec3 b, double t) {
        return a.m_82549_(b.m_82546_(a).m_82490_(t));
    }

    private static final class Flight {
        final ItemStack stack;
        final Vec3 from;
        final Vec3 to;
        final long startTime;
        final int durationTicks;
        final double spinTurns;
        final float yawDeg;

        Flight(FlightPayload p, RandomSource rng) {
            this.stack = p.stack();
            Vec3 rawFrom = p.from();
            Vec3 rawTo = p.to();
            Vec3 dir = rawTo.m_82546_(rawFrom);
            double dist = Math.max(1.0E-4, dir.m_82553_());
            dir = dir.m_82490_(1.0 / dist);
            this.from = rawFrom.m_82549_(dir.m_82490_(0.25));
            this.to = rawTo;
            this.startTime = p.startGameTime();
            this.durationTicks = Math.max(1, p.durationTicks());
            this.spinTurns = 2.25 + rng.m_188500_() * 0.75;
            Vec3 fwd = rawTo.m_82546_(rawFrom);
            double yawRad = Math.atan2(fwd.f_82479_, fwd.f_82481_);
            this.yawDeg = (float)(yawRad * 180.0 / Math.PI);
        }
    }

    public record FlightPayload(ItemStack stack, Vec3 from, Vec3 to, long startGameTime, int durationTicks) {
    }
}

