/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;

public class CookingLogicContainer<T extends AbstractCookingRecipe> {
    private final Supplier<CookingLogic<T>> supplyCoookingLogic;
    private final List<Slot> smeltingSlots = new ArrayList<Slot>();
    private int removeCount;
    private final Player player;

    public CookingLogicContainer(final Player player, final Supplier<CookingLogic<T>> supplyCoookingLogic, Consumer<Slot> addSlot) {
        this.player = player;
        this.supplyCoookingLogic = supplyCoookingLogic;
        this.addSmeltingSlot(addSlot, (Slot)new SlotSuppliedHandler(() -> ((CookingLogic)supplyCoookingLogic.get()).getCookingInventory(), 0, -100, -100));
        this.addSmeltingSlot(addSlot, (Slot)new SlotSuppliedHandler(() -> ((CookingLogic)supplyCoookingLogic.get()).getCookingInventory(), 1, -100, -100));
        this.addSmeltingSlot(addSlot, (Slot)new SlotSuppliedHandler(() -> ((CookingLogic)supplyCoookingLogic.get()).getCookingInventory(), 2, -100, -100){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public ItemStack m_6201_(int amount) {
                if (this.m_6657_()) {
                    CookingLogicContainer.this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
                }
                return super.m_6201_(amount);
            }

            public void m_142406_(Player player2, ItemStack stack) {
                this.m_5845_(stack);
                super.m_142406_(player2, stack);
            }

            protected void m_5845_(ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, CookingLogicContainer.this.removeCount);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    ((CookingLogic)supplyCoookingLogic.get()).awardUsedRecipesAndPopExperience(serverplayer);
                }
                CookingLogicContainer.this.removeCount = 0;
                ForgeEventFactory.firePlayerSmeltedEvent((Player)player, (ItemStack)stack);
            }
        });
    }

    private void addSmeltingSlot(Consumer<Slot> addSlot, Slot slot) {
        addSlot.accept(slot);
        this.smeltingSlots.add(slot);
    }

    public int getBurnTimeTotal() {
        return this.supplyCoookingLogic.get().getBurnTimeTotal();
    }

    public long getBurnTimeFinish() {
        return this.supplyCoookingLogic.get().getBurnTimeFinish();
    }

    public long getCookTimeFinish() {
        return this.supplyCoookingLogic.get().getCookTimeFinish();
    }

    public int getCookTimeTotal() {
        return this.supplyCoookingLogic.get().getCookTimeTotal();
    }

    public boolean isCooking() {
        return this.supplyCoookingLogic.get().isCooking();
    }

    public boolean isBurning(Level world) {
        return this.supplyCoookingLogic.get().isBurning(world);
    }

    public List<Slot> getCookingSlots() {
        return this.smeltingSlots;
    }
}

