/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SingleSlotBlockEntity
extends BlockEntity
implements ContainerSingleItem,
Clearable,
Nameable {
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    protected LazyOptional<?> itemHandler = LazyOptional.of(() -> this.createUnSidedHandler());

    public SingleSlotBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static InteractionResult use(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SingleSlotBlockEntity)) {
            return InteractionResult.FAIL;
        }
        SingleSlotBlockEntity blockEntity2 = (SingleSlotBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        ItemStack storedItem = blockEntity2.m_8020_(0);
        if (heldItem.m_41619_() && !storedItem.m_41619_()) {
            blockEntity2.m_6211_();
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, storedItem);
            } else if (!player.m_150109_().m_36054_(storedItem)) {
                player.m_36176_(storedItem, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * player.m_217043_().m_188501_());
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_() && (storedItem.m_41619_() || storedItem.m_41613_() < storedItem.m_41741_() && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)storedItem)) && blockEntity2.m_7013_(0, heldItem)) {
            ItemStack itemStack = heldItem.m_41620_(Math.min(storedItem.m_41741_() - storedItem.m_41613_(), heldItem.m_41613_()));
            itemStack.m_41769_(storedItem.m_41613_());
            blockEntity2.m_6836_(0, itemStack);
            level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * player.m_217043_().m_188501_());
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_()) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    public static void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SingleSlotBlockEntity) {
            SingleSlotBlockEntity blockEntity2 = (SingleSlotBlockEntity)blockEntity;
            blockEntity2.dropContents();
            level.m_46717_(pos, blockState.m_60734_());
        }
    }

    public void dropContents() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.inventory);
            this.m_6596_();
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> this.createUnSidedHandler());
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.inventory.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.getInventory(), (int)pSlot, (int)pAmount);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.getInventory(), (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.getInventory().set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20182_().m_82509_((Position)Vec3.m_82512_((Vec3i)this.m_58899_()), 8.0);
    }

    public void m_6211_() {
        this.inventory.clear();
        this.m_6596_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128425_(this.getItemNbtKey(), 10)) {
            this.m_6836_(0, ItemStack.m_41712_((CompoundTag)pTag.m_128469_(this.getItemNbtKey())));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_(this.getItemNbtKey(), (Tag)((ItemStack)this.getInventory().get(0)).m_41739_(new CompoundTag()));
    }

    protected String getItemNbtKey() {
        return "Item";
    }

    public Component m_7755_() {
        return this.m_8020_(0).m_41786_();
    }

    @Nullable
    public Component m_7770_() {
        ItemStack itemStack = this.m_8020_(0);
        if (itemStack.m_41619_() || !itemStack.m_41788_()) {
            return null;
        }
        return itemStack.m_41786_();
    }
}

