/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TanukiDecor;

public class SlotMachineBlockEntity
extends BlockEntity {
    public static int USE_DURATION = 120;
    protected long startTime;
    protected boolean active;
    protected Vec3i slotRotations = new Vec3i(0, 2, 1);
    private static final String KEY_TIMESTAMP = "StartTime";
    private static final String KEY_SLOT_ROTATIONS = "SlotRotations";

    public SlotMachineBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SlotMachineBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (blockEntity.isActive() && blockEntity.getStartTime() > 0L) {
            int timeElapsed = (int)(level.m_46467_() - blockEntity.getStartTime());
            if (timeElapsed % (2 + timeElapsed / 16) == 0) {
                level.m_5594_(null, blockPos, SoundEvents.f_12444_, SoundSource.BLOCKS, 0.25f, 0.9f);
            }
            if (timeElapsed > USE_DURATION) {
                blockEntity.stop(level);
            }
        }
    }

    public static InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SlotMachineBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (!(blockEntity2 instanceof SlotMachineBlockEntity) || (blockEntity = (SlotMachineBlockEntity)blockEntity2).isActive()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        blockEntity.start(level);
        return InteractionResult.SUCCESS;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(1.0);
    }

    public boolean isActive() {
        return this.active;
    }

    public void start(Level level) {
        this.active = true;
        if (!level.m_5776_()) {
            this.startTime = level.m_46467_();
            this.slotRotations = this.createSlotRotations(level.m_213780_());
            this.m_6596_();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            level.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            level.m_46717_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_());
            level.m_5594_(null, this.m_58899_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.5f, 0.8f + level.m_213780_().m_188501_() * 0.4f);
        }
    }

    public void stop(Level level) {
        this.active = false;
        if (!level.m_5776_()) {
            this.startTime = 0L;
            this.m_6596_();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            level.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            level.m_46717_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_());
            if (this.isJackpot()) {
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 0.8f + level.m_213780_().m_188501_() * 0.4f);
            }
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public float getUsePercentage(float partialTick) {
        if (!this.active) {
            return 1.0f;
        }
        int useTime = (int)(this.m_58904_().m_46467_() - this.startTime);
        return Mth.m_14179_((float)partialTick, (float)(useTime - 1), (float)useTime) / (float)USE_DURATION;
    }

    public Vec3i createSlotRotations(RandomSource random) {
        double jackboxChance = (Double)TanukiDecor.CONFIG.slotMachineJackboxChance.get();
        if (random.m_188500_() * 100.0 < jackboxChance) {
            int n = random.m_188503_(4);
            return new Vec3i(n, n, n);
        }
        return new Vec3i(random.m_188503_(4), random.m_188503_(4), random.m_188503_(4));
    }

    public Vec3i getSlotRotations() {
        return this.slotRotations;
    }

    public void setSlotRotations(Vec3i rotations) {
        this.slotRotations = new Vec3i(Mth.m_14045_((int)rotations.m_123341_(), (int)0, (int)3), Mth.m_14045_((int)rotations.m_123342_(), (int)0, (int)3), Mth.m_14045_((int)rotations.m_123343_(), (int)0, (int)3));
    }

    public boolean isJackpot() {
        return this.slotRotations.m_123341_() == this.slotRotations.m_123342_() && this.slotRotations.m_123342_() == this.slotRotations.m_123343_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.startTime = pTag.m_128454_(KEY_TIMESTAMP);
        boolean bl = this.active = this.startTime > 0L;
        if (pTag.m_128425_(KEY_SLOT_ROTATIONS, 10)) {
            CompoundTag slotTag = pTag.m_128469_(KEY_SLOT_ROTATIONS);
            this.slotRotations = new Vec3i(slotTag.m_128451_("x"), slotTag.m_128451_("y"), slotTag.m_128451_("z"));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128356_(KEY_TIMESTAMP, this.startTime);
        this.writeSlotRotations(pTag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128356_(KEY_TIMESTAMP, this.startTime);
        this.writeSlotRotations(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void writeSlotRotations(CompoundTag tag) {
        CompoundTag slotTag = new CompoundTag();
        slotTag.m_128405_("x", this.slotRotations.m_123341_());
        slotTag.m_128405_("y", this.slotRotations.m_123342_());
        slotTag.m_128405_("z", this.slotRotations.m_123343_());
        tag.m_128365_(KEY_SLOT_ROTATIONS, (Tag)slotTag);
    }
}

