/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.client.blockentity.clock.ClockBER;

public class StationClockBER
extends ClockBER {
    public static final ResourceLocation SHORT_HAND = new ResourceLocation("tanukidecor", "block/station_clock/short_hand");
    public static final ResourceLocation LONG_HAND = new ResourceLocation("tanukidecor", "block/station_clock/long_hand");

    public StationClockBER(BlockEntityRendererProvider.Context pContext) {
        super(pContext, SHORT_HAND, LONG_HAND, new Vec3(0.5, 0.5, 0.5), ROOT_PIVOT_POINT, new Vec3(-0.5, 0.5, -0.0925), new Vec3(0.5, 0.5, 0.0));
    }

    @Override
    public void render(ClockBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = pBlockEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Level level = pBlockEntity.m_58904_();
        long dayTime = (level.m_46468_() + 6000L) % 24000L;
        float hourAngleInterval = 0.5235988f;
        float hourRotation = ClockBlockEntity.getHour(dayTime, pPartialTick) * 0.5235988f;
        float minuteRotation = ClockBlockEntity.getMinute(dayTime, 0.98f) * ((float)Math.PI * 2);
        pPoseStack.m_85836_();
        this.clockRenderHelper.withPoseStack(pPoseStack).withBlockState(blockState).withRenderType(pBufferSource, RenderType.m_110463_()).withPackedLight(pPackedLight).withPackedOverlay(pPackedOverlay).withPartialTick(pPartialTick).withRotationZ(0.0f);
        this.clockRenderHelper.withPosition(this.rootPosition).withPivotPoint(this.rootPivotPoint).rotateForDirection(direction);
        pPoseStack.m_85837_(-0.5, -0.5, -0.40625);
        for (int i = 0; i < 2; ++i) {
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.shortHand)).withPosition(this.handsPosition).withPivotPoint(this.handsPivotPoint).withRotationZ(hourRotation).render(this.blockRenderer);
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.longHand)).withRotationZ(minuteRotation).render(this.blockRenderer);
            this.renderAdditional(this.clockRenderHelper, pBlockEntity, pBufferSource);
            pPoseStack.m_252781_(Axis.f_252436_.m_252961_((float)Math.PI));
            pPoseStack.m_85837_(0.0, 0.0, -0.8125);
        }
        pPoseStack.m_85849_();
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(SHORT_HAND);
        list.add(LONG_HAND);
    }
}

