/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import tanukidecor.TDRegistry;
import tanukidecor.block.entity.DIYWorkbenchBlockEntity;

public class DIYRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack result;

    public DIYRecipe(ResourceLocation id, ItemStack result) {
        this.id = id;
        this.result = result;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        for (int i = 0; i < 4; ++i) {
            Ingredient ingredient = DIYWorkbenchBlockEntity.INGREDIENTS[i];
            ItemStack itemStack = pContainer.m_8020_(i);
            if (ingredient.test(itemStack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 4;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TDRegistry.RecipeReg.DIY_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TDRegistry.RecipeReg.DIY.get();
    }

    public static class Serializer
    implements RecipeSerializer<DIYRecipe> {
        public static final String CATEGORY = "diy";
        private static final String KEY_RESULT = "result";

        public DIYRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)KEY_RESULT));
            return new DIYRecipe(recipeId, result);
        }

        public DIYRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack result = buffer.m_130267_();
            return new DIYRecipe(recipeId, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, DIYRecipe recipe) {
            buffer.writeItemStack(recipe.result, false);
        }
    }
}

