/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class Gradient {
    private final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private final List<Entry> colors;

    private Gradient(List<Entry> colors) {
        if (colors.isEmpty()) {
            throw new IllegalArgumentException("Failed to build Gradient with empty list");
        }
        this.colors = ImmutableList.sortedCopyOf(Comparator.reverseOrder(), colors);
    }

    public Vector4f getColor(float percent) {
        int n = this.colors.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = this.colors.get(i);
            if (!(percent > entry.threshold)) continue;
            return entry.color();
        }
        return this.ONE;
    }

    public static Vector4f unpackColor(int color) {
        long tmpColor = color;
        if ((tmpColor & 0xFFFFFFFFFF000000L) == 0L) {
            tmpColor |= 0xFFFFFFFFFF000000L;
        }
        float colorRed = (float)(tmpColor >> 16 & 0xFFL) / 255.0f;
        float colorGreen = (float)(tmpColor >> 8 & 0xFFL) / 255.0f;
        float colorBlue = (float)(tmpColor & 0xFFL) / 255.0f;
        float colorAlpha = (float)(tmpColor >> 24 & 0xFFL) / 255.0f;
        return new Vector4f(colorRed, colorGreen, colorBlue, colorAlpha);
    }

    private record Entry(float threshold, Vector4f color) implements Comparable<Entry>
    {
        private Entry(float threshold, Vector4f color) {
            this.threshold = Mth.m_14036_((float)threshold, (float)0.0f, (float)1.0f);
            this.color = new Vector4f(Mth.m_14036_((float)color.x(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.y(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.z(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.w(), (float)0.0f, (float)1.0f));
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            return Float.compare(this.threshold, o.threshold);
        }
    }

    public static class Builder {
        private final List<Entry> list = new ArrayList<Entry>();

        public Builder(int color) {
            this(Gradient.unpackColor(color));
        }

        public Builder(Vector4f color) {
            this.list.add(new Entry(0.0f, color));
        }

        public Builder with(float threshold, int color) {
            this.list.add(new Entry(threshold, Gradient.unpackColor(color)));
            return this;
        }

        public Builder with(float threshold, Vector4f color) {
            this.list.add(new Entry(threshold, color));
            return this;
        }

        public Gradient build() {
            return new Gradient(this.list);
        }
    }
}

