/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.tanks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TFMGFluidTankRenderer
extends SafeBlockEntityRenderer<FluidTankBlockEntity> {
    public TFMGFluidTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(FluidTankBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        LerpedFloat fluidLevel = te.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)te.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = te.getTankInventory();
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        float xMin = tankHullWidth;
        float xMax = xMin + (float)te.getWidth() - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)te.getWidth() - 2.0f * tankHullWidth;
        ms.m_85836_();
        ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(FluidTankBlockEntity te) {
        return te.isController();
    }
}

