/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.polarizer;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.recipes.PolarizingRecipe;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarizerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this, 1, false).whenContentsChanged(this::onInventoryChanged);
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    LerpedFloat angle = LerpedFloat.angular();
    public boolean chargeCapacitors = false;
    public int capacitorPercentage = 0;

    public PolarizerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
    }

    public void onInventoryChanged(int count) {
        this.sendData();
        this.m_6596_();
        if (this.inventory.m_7983_()) {
            this.chargeCapacitors = false;
            this.updateNextTick();
            return;
        }
        ItemStack itemStack = this.inventory.m_8020_(0);
        if (this.getRecipe(itemStack).isPresent()) {
            this.chargeCapacitors = true;
            this.updateNextTick();
            if (this.capacitorPercentage >= 200) {
                this.performRecipe(this.getRecipe(itemStack).get());
            }
        } else {
            this.chargeCapacitors = false;
            this.updateNextTick();
        }
    }

    @Override
    public float resistance() {
        return this.chargeCapacitors ? 30.0f : 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getPowerUsage() < 2000 && !this.inventory.m_7983_()) {
            CreateLang.translate((String)"goggles.polarizer.insufficient_power", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            return true;
        }
        CreateLang.translate((String)"goggles.polarizer.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"goggles.polarizer.charge", (Object[])new Object[0]).add(CreateLang.text((String)((float)this.capacitorPercentage / 2.0f + "%"))).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip);
        return true;
    }

    @Override
    public boolean canBeInGroups() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.angle.chase((double)(180.0f * ((float)this.capacitorPercentage / 200.0f)), (double)0.2f, LerpedFloat.Chaser.EXP);
            this.angle.tickChaser();
        }
        if (this.getPowerUsage() >= 2000 && this.chargeCapacitors) {
            if (this.capacitorPercentage < 200) {
                ++this.capacitorPercentage;
            } else {
                this.onInventoryChanged(this.inventory.getStackInSlot(0).m_41613_());
            }
        }
    }

    public void performRecipe(PolarizingRecipe recipe) {
        ItemStack stack = ((ProcessingOutput)recipe.getRollableResults().get(0)).rollOutput();
        this.inventory.setStackInSlot(0, stack);
        TFMGUtils.spawnElectricParticles(this.f_58857_, this.m_58899_());
        this.capacitorPercentage = 0;
    }

    public Optional<PolarizingRecipe> getRecipe(ItemStack item) {
        if (!this.m_58898_()) {
            return Optional.empty();
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, TFMGRecipeTypes.POLARIZING.getType(), PolarizingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return TFMGRecipeTypes.POLARIZING.find(this.inventory, this.f_58857_);
    }

    public int getItemChargingRate() {
        return (Integer)TFMGConfigs.common().machines.polarizerItemChargingRate.get();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("CapacitorPercentage", this.capacitorPercentage);
        compound.m_128379_("ChargeCapacitors", this.chargeCapacitors);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.capacitorPercentage = compound.m_128451_("CapacitorPercentage");
        this.chargeCapacitors = compound.m_128471_("ChargeCapacitors");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

