/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.mixin;

import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipeModelData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PipeAttachmentModel.class})
public class PipeAttachmentModelMixin
extends BakedModelWrapperWithData {
    private static final ModelProperty<TFMGPipeModelData> PIPE_PROPERTY = new ModelProperty();

    public PipeAttachmentModelMixin(BakedModel template) {
        super(template);
    }

    @Overwrite(remap=false)
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        TFMGPipeModelData data = new TFMGPipeModelData();
        FluidTransportBehaviour transport = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)FluidTransportBehaviour.TYPE);
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (transport != null) {
            for (Direction d : Iterate.directions) {
                boolean shouldConnect = true;
                if (world.m_8055_(pos.m_121945_(d)).m_60734_() instanceof FluidPipeBlock && d.m_122434_().m_122479_()) {
                    shouldConnect = (Boolean)world.m_8055_(pos.m_121945_(d)).m_61143_((Property)PipeBlock.f_55154_.get(d.m_122424_()));
                }
                data.putAttachment(d, transport.getRenderedRimAttachment(world, pos, state, d));
                if (shouldConnect || !(state.m_60734_() instanceof FluidPipeBlock) || !((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(d))).booleanValue()) continue;
                data.putAttachment(d, FluidTransportBehaviour.AttachmentTypes.RIM);
            }
        }
        if (bracket != null) {
            data.putBracket(bracket.getBracket());
        }
        data.setEncased(FluidPipeBlock.shouldDrawCasing((BlockAndTintGetter)world, (BlockPos)pos, (BlockState)state));
        return builder.with(PIPE_PROPERTY, (Object)data);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet set = super.getRenderTypes(state, rand, data);
        if (set.isEmpty()) {
            return ItemBlockRenderTypes.getRenderLayers((BlockState)state);
        }
        return set;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, data, renderType);
        if (data.has(PIPE_PROPERTY)) {
            TFMGPipeModelData pipeData = (TFMGPipeModelData)data.get(PIPE_PROPERTY);
            quads = new ArrayList<BakedQuad>(quads);
            this.addQuads(quads, state, side, rand, data, pipeData, renderType);
        }
        return quads;
    }

    private void addQuads(List<BakedQuad> quads, BlockState state, Direction side, RandomSource rand, ModelData data, TFMGPipeModelData pipeData, RenderType renderType) {
        BakedModel bracket = pipeData.getBracket();
        if (bracket != null) {
            quads.addAll(bracket.getQuads(state, side, rand, data, renderType));
        }
        for (Direction d : Iterate.directions) {
            FluidTransportBehaviour.AttachmentTypes type = pipeData.getAttachment(d);
            for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial : type.partials) {
                quads.addAll(((PartialModel)((Map)AllPartialModels.PIPE_ATTACHMENTS.get(partial)).get(d)).get().getQuads(state, side, rand, data, renderType));
            }
        }
        if (pipeData.isEncased()) {
            quads.addAll(AllPartialModels.FLUID_PIPE_CASING.get().getQuads(state, side, rand, data, renderType));
        }
    }
}

