/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes;

import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class VatMachineRecipe
extends ProcessingRecipe<RecipeWrapper> {
    public List<String> machines = new ArrayList<String>();
    public List<String> allowedVatTypes = new ArrayList<String>();
    public int minSize;
    public int heatLevel = 0;

    public VatMachineRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)TFMGRecipeTypes.VAT_MACHINE_RECIPE, params);
    }

    protected int getMaxInputCount() {
        return 4;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 4;
    }

    protected int getMaxFluidOutputCount() {
        return 4;
    }

    public void readAdditional(JsonObject json) {
        JsonArray vatTypeArray;
        super.readAdditional(json);
        JsonArray machineArray = json.getAsJsonArray("machines");
        if (machineArray != null) {
            for (int i = 0; i < machineArray.size(); ++i) {
                this.machines.add(machineArray.get(i).getAsString());
            }
        }
        if ((vatTypeArray = json.getAsJsonArray("allowedVatTypes")) != null) {
            for (int i = 0; i < vatTypeArray.size(); ++i) {
                this.allowedVatTypes.add(vatTypeArray.get(i).getAsString());
            }
        }
        this.minSize = GsonHelper.m_13824_((JsonObject)json, (String)"minSize", (int)1);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        JsonArray machineArray = new JsonArray();
        for (String string : this.machines) {
            machineArray.add(string);
        }
        json.add("machines", (JsonElement)machineArray);
        JsonArray vatTypeArray = new JsonArray();
        for (String string : this.allowedVatTypes) {
            vatTypeArray.add(string);
        }
        json.add("allowedVatTypes", (JsonElement)vatTypeArray);
        json.addProperty("minSize", (Number)this.minSize);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return false;
    }
}

