/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.fluid.AcidFluidType;
import com.drmangotea.tfmg.base.fluid.AsphaltFluid;
import com.drmangotea.tfmg.base.fluid.ConcreteFluid;
import com.drmangotea.tfmg.base.fluid.HotFluidType;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.joml.Vector3f;

public class TFMGFluids {
    public static final FluidEntry<VirtualFluid> LPG = TFMGFluids.gasFuel("lpg", -661881, TFMGTags.TFMGFluidTags.LPG.tag, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<VirtualFluid> BUTANE = TFMGFluids.gasFuel("butane", -5408812, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<VirtualFluid> PROPANE = TFMGFluids.gasFuel("propane", -7815296, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<VirtualFluid> HYDROGEN = TFMGFluids.gasFuel("hydrogen", -3083531, new TagKey[0]);
    public static final FluidEntry<VirtualFluid> FURNACE_GAS = TFMGFluids.gasFuel("furnace_gas", -10726059, TFMGTags.TFMGFluidTags.BLAST_STOVE_FUEL.tag, TFMGTags.TFMGFluidTags.FURNACE_GAS.tag);
    public static final FluidEntry<VirtualFluid> ETHYLENE = TFMGFluids.gas("ethylene", -4411956, new TagKey[0]);
    public static final FluidEntry<VirtualFluid> PROPYLENE = TFMGFluids.gas("propylene", -4140620, new TagKey[0]);
    public static final FluidEntry<VirtualFluid> NEON = TFMGFluids.gas("neon", -6427159, new TagKey[0]);
    public static final FluidEntry<VirtualFluid> CARBON_DIOXIDE = TFMGFluids.gas("carbon_dioxide", -11382190, new TagKey[0]);
    public static final FluidEntry<VirtualFluid> AIR = TFMGFluids.gas("air", -2103579, TFMGTags.TFMGFluidTags.AIR.tag);
    public static final FluidEntry<VirtualFluid> HOT_AIR = TFMGFluids.gas("hot_air", -1515051, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CRUDE_OIL = TFMGFluids.fluid("crude_oil", 65793, TFMGTags.TFMGFluidTags.CRUDE_OIL.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HEAVY_OIL = TFMGFluids.fluid("heavy_oil", 65793, TFMGTags.TFMGFluidTags.HEAVY_OIL.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GASOLINE = TFMGFluids.fuel("gasoline", 13414781, TFMGTags.TFMGFluidTags.GASOLINE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> DIESEL = TFMGFluids.fuel("diesel", 12491908, TFMGTags.TFMGFluidTags.DIESEL.tag, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> NAPHTHA = TFMGFluids.fuel("naphtha", 6829349, TFMGTags.TFMGFluidTags.NAPHTHA.tag, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> KEROSENE = TFMGFluids.fuel("kerosene", 8159957, TFMGTags.TFMGFluidTags.KEROSENE.tag, TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CREOSOTE = TFMGFluids.fuel("creosote", 65793, TFMGTags.TFMGFluidTags.CREOSOTE.tag, TFMGTags.TFMGFluidTags.BLAST_STOVE_FUEL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_STEEL = TFMGFluids.hotFluid("molten_steel", 16775008, TFMGTags.TFMGFluidTags.MOLTEN_STEEL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_SLAG = TFMGFluids.hotFluid("molten_slag", 16775008, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_PLASTIC = TFMGFluids.hotFluid("molten_plastic", 14607615, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_SILICON = TFMGFluids.hotFluid("liquid_silicon", 16775008, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LUBRICATION_OIL = TFMGFluids.fluid("lubrication_oil", 10327135, TFMGTags.TFMGFluidTags.LUBRICATION_OIL.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> COOLING_FLUID = TFMGFluids.fluid("cooling_fluid", 8110529, TFMGTags.TFMGFluidTags.COOLING_FLUID.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> NAPALM = TFMGFluids.fluid("napalm", 12634775, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SULFURIC_ACID = TFMGFluids.acidFluid("sulfuric_acid", 15329228, new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_CONCRETE = TFMGFluids.concreteFluid("liquid_concrete", 0x5B5B59, (NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid>)((NonNullFunction)ConcreteFluid.Source::new), new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_ASPHALT = TFMGFluids.concreteFluid("liquid_asphalt", 65793, (NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid>)((NonNullFunction)AsphaltFluid.Source::new), new TagKey[0]);

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> fluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.fluid(name, TFMGFluids.getLocation(name), TFMGFluids.getLocationFlow(name), SolidRenderedPlaceableFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(TFMGUtils.toHumanReadable(name)).properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> acidFluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.fluid(name, TFMGFluids.getLocation(name), TFMGFluids.getLocationFlow(name), AcidFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(TFMGUtils.toHumanReadable(name)).properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> fuel(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.fluid(name, TFMGFluids.getLocation(name), TFMGFluids.getLocationFlow(name), SolidRenderedPlaceableFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(TFMGUtils.toHumanReadable(name)).properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).tag(tags).tag(new TagKey[]{TFMGTags.TFMGFluidTags.FUEL.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag}).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> hotFluid(String name, int fogColor, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.fluid(name, TFMGFluids.getLocation(name), TFMGFluids.getLocationFlow(name), HotFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(TFMGUtils.toHumanReadable(name)).properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(3).slopeFindDistance(3).explosionResistance(100.0f)).tag(tags).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    private static FluidEntry<ForgeFlowingFluid.Flowing> concreteFluid(String name, int fogColor, NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid> factory, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.fluid(name, TFMGFluids.getLocation(name), TFMGFluids.getLocationFlow(name), SolidRenderedPlaceableFluidType.create(fogColor, () -> Float.valueOf(0.03125f))).lang(TFMGUtils.toHumanReadable(name)).properties(b -> b.viscosity(5000).density(2500)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(99999).slopeFindDistance(1).explosionResistance(1000.0f)).tag(tags).source(factory).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    public static FluidEntry<VirtualFluid> gas(String name, int color, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.gasFluid(name, color).lang(TFMGUtils.fromId(name)).tag(tags).tag(new TagKey[]{TFMGTags.TFMGFluidTags.GAS.tag}).bucket().lang(TFMGUtils.fromId(name) + " Tank").tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    public static FluidEntry<VirtualFluid> gasFuel(String name, int color, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)TFMG.REGISTRATE.gasFluid(name, color).lang(TFMGUtils.fromId(name)).tag(tags).tag(new TagKey[]{TFMGTags.TFMGFluidTags.GAS.tag}).tag(new TagKey[]{TFMGTags.TFMGFluidTags.FUEL.tag}).tag(new TagKey[]{TFMGTags.TFMGFluidTags.FLAMMABLE.tag}).bucket().lang(TFMGUtils.fromId(name) + " Tank").tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    public static ResourceLocation getGasLocation(String name) {
        return TFMG.asResource("fluid/" + name);
    }

    public static ResourceLocation getGasTexture() {
        return TFMG.asResource("fluid/gas_texture");
    }

    public static ResourceLocation getLocation(String name) {
        return TFMG.asResource("fluid/" + name + "_still");
    }

    public static ResourceLocation getLocationFlow(String name) {
        return TFMG.asResource("fluid/" + name + "_flow");
    }

    public static void init() {
    }

    public static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        public SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

