/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc;

import com.google.common.base.Stopwatch;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.VSC;
import net.mehvahdjukaar.vsc.forge.CutBlockTypeRegistryImpl;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import org.jetbrains.annotations.Contract;

public class CutBlockTypeRegistry
extends BlockTypeRegistry<CutBlockType> {
    public static final CutBlockType STONE_TYPE = new CutBlockType(new ResourceLocation("stone"), Blocks.f_50069_, Blocks.f_50404_);
    private final List<String> dyes = Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_).sorted(Comparator.comparingInt(String::length)).sorted(Collections.reverseOrder()).toList();
    private final Set<String> blacklist = Set.of("securitycraft", "betterend", "betternether");

    protected CutBlockTypeRegistry(String name) {
        super(CutBlockType.class, name);
    }

    public CutBlockType getDefaultType() {
        return STONE_TYPE;
    }

    public Optional<CutBlockType> detectTypeFromBlock(Block block, ResourceLocation baseRes) {
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_slab") && !path.endsWith("_vertical_slab")) {
            name = path.substring(0, path.length() - "_slab".length());
        } else if (path.startsWith("slab_")) {
            name = path.substring("slab_".length());
        }
        String namespace = baseRes.m_135827_();
        if (name != null && block instanceof SlabBlock && !this.blacklist.contains(namespace)) {
            ResourceLocation id = new ResourceLocation(namespace, name);
            Optional parent = BuiltInRegistries.f_256975_.m_6612_(id);
            if (parent.isEmpty() && namespace.equals("absentbydesign")) {
                String finalName = name.replace("silver", "light_gray");
                for (String d : this.dyes) {
                    if (!finalName.contains(d)) continue;
                    String n = d + "_" + finalName.replace("_" + d, "");
                    parent = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(n));
                    if (!parent.isPresent()) break;
                    id = new ResourceLocation("absentbydesign", n);
                    break;
                }
                name = name.replace("bricks_cracked", "cracked_stone_bricks");
            }
            if (parent.isEmpty()) {
                parent = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(namespace, name + "s"));
            }
            if (parent.isEmpty()) {
                parent = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(namespace, name + "_planks"));
            }
            if (parent.isEmpty()) {
                parent = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(name));
            }
            if (parent.isPresent() && CutBlockTypeRegistry.hasRightShapeHack(block)) {
                return Optional.of(new CutBlockType(id, (Block)parent.get(), block));
            }
        }
        return Optional.empty();
    }

    public void buildAll() {
        Stopwatch watch = Stopwatch.createStarted();
        super.buildAll();
        VSC.LOGGER.info("Initialized slab sets in: {} ms", (Object)watch.elapsed().toMillis());
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasRightShapeHack(Block block) {
        return CutBlockTypeRegistryImpl.hasRightShapeHack(block);
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }
}

