/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.CutBlockTypeRegistry;
import net.mehvahdjukaar.vsc.VSCClient;
import net.mehvahdjukaar.vsc.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.vsc.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.vsc.temp.QuarkCompat;
import net.mehvahdjukaar.vsc.temp.TempVerticalSlabBlock;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VSC {
    public static final String MOD_ID = "v_slab_compat";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final List<String> VERTICAL_SLABS_MODS = Stream.of("quark", "buildersaddition", "compatoplenty", "everycomp").filter(PlatHelper::isModLoaded).toList();
    public static final Map<CutBlockType, Block> VERTICAL_SLABS = new Object2ObjectOpenHashMap();
    public static final Map<CutBlockType, Item> VERTICAL_SLABS_ITEMS = new Object2ObjectOpenHashMap();
    public static Supplier<List<String>> BLACKLIST;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        ConfigBuilder c = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        BLACKLIST = c.comment("mod ids blacklist").define("blacklist", List.of("securitycraft"), o -> o instanceof String);
        c.buildAndRegister().loadFromFile();
        if (PlatHelper.getPhysicalSide().isClient()) {
            VSCClient.init();
        }
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)new CutBlockTypeRegistry("cut_block_type"));
        BlockSetAPI.addDynamicBlockRegistration(VSC::registerVerticalSlab, CutBlockType.class);
        BlockSetAPI.addDynamicRegistration(VSC::registerItems, CutBlockType.class, (Registry)BuiltInRegistries.f_257033_);
        ServerDynamicResourcesHandler.INSTANCE.register();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientDynamicResourcesHandler.INSTANCE.register();
        }
        RegHelper.addItemsToTabsRegistration(VSC::addItemsToTabs);
    }

    private static void registerItems(Registrator<Item> itemRegistrator, Collection<CutBlockType> types) {
        for (Map.Entry<CutBlockType, Block> v : VERTICAL_SLABS.entrySet()) {
            CutBlockType type = v.getKey();
            Block block = v.getValue();
            Item.Properties prop = new Item.Properties();
            Object i = type.getWoodType() != null ? new WoodBasedBlockItem(block, prop, type.getWoodType(), 150) : new BlockItem(block, prop);
            itemRegistrator.register(Utils.getID((Block)v.getValue()), i);
            VERTICAL_SLABS_ITEMS.put(type, (Item)i);
        }
    }

    private static void registerVerticalSlab(Registrator<Block> blockRegistrator, Collection<CutBlockType> types) {
        for (CutBlockType type : types) {
            if (type.getChild("vertical_slab") != null) continue;
            String name = type.getTypeName() + "_vertical_slab";
            ResourceLocation newId = VSC.res(type.getNamespace().equals("minecraft") ? name : type.getNamespace() + "/" + name);
            Block block = VSC.createVSlab(type);
            blockRegistrator.register(newId, (Object)block);
            VERTICAL_SLABS.put(type, block);
            type.addChild("vertical_slab", block);
        }
    }

    @NotNull
    private static Block createVSlab(CutBlockType type) {
        return QUARK ? QuarkCompat.createVSlab(type) : new TempVerticalSlabBlock(Utils.copyPropertySafe((Block)type.base), type);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        for (Map.Entry<CutBlockType, Item> v : VERTICAL_SLABS_ITEMS.entrySet()) {
            String namespace = v.getKey().getNamespace();
            if (BLACKLIST.get().contains(namespace)) continue;
            event.addAfter(CreativeModeTabs.f_256788_, i -> i.m_150930_(((CutBlockType)((Object)((Object)v.getKey()))).slab.m_5456_()), new ItemLike[]{(ItemLike)v.getValue()});
        }
    }
}

