/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.block.entity;

import net.chaolux.vanilladelight.common.block.CommonCabinetBlock;
import net.chaolux.vanilladelight.registry.block.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CommonCabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            CommonCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_OPEN.get());
            CommonCabinetBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            CommonCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_CLOSE.get());
            CommonCabinetBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState sta, int arg1, int arg2) {
        }

        protected boolean m_142718_(Player p_155060_) {
            if (p_155060_.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)p_155060_.f_36096_).m_39261_();
                return container == CommonCabinetBlockEntity.this;
            }
            return false;
        }
    };

    public CommonCabinetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.COMMON_CABINET.get(), pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.contents);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.contents);
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.contents;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.contents = itemsIn;
    }

    protected Component m_6820_() {
        return TextUtils.getTranslation((String)"container.cabinet", (Object[])new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    public void m_5856_(Player pPlayer) {
        if (this.f_58857_ != null && !this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (this.f_58857_ != null && !this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (this.f_58857_ != null && !this.f_58859_) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CommonCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        if (this.f_58857_ != null) {
            Vec3i cabinetFacingVector = ((Direction)state.m_61143_((Property)CommonCabinetBlock.FACING)).m_122436_();
            double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)cabinetFacingVector.m_123341_() / 2.0;
            double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)cabinetFacingVector.m_123342_() / 2.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)cabinetFacingVector.m_123343_() / 2.0;
            this.f_58857_.m_6263_((Player)null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

