/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.block.custom;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.ribs.vintagedelight.item.ModItems;

public class MasonJarBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty JARS = IntegerProperty.m_61631_((String)"jars", (int)1, (int)4);
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape ONE_JAR_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.75, (double)11.0);
    private static final VoxelShape TWO_JAR_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)15.0, (double)11.75, (double)15.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)9.0, (double)11.75, (double)15.0));
    private static final VoxelShape THREE_JAR_AABB = Shapes.m_83110_((VoxelShape)TWO_JAR_AABB, (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)11.75, (double)7.0));
    private static final VoxelShape FOUR_JAR_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.75, (double)15.0);
    public static final int MAX_JARS = 4;

    public MasonJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)JARS, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JARS, FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int jars;
        boolean isWaterlogged;
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = isWaterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockstate.m_60713_((Block)this) && (jars = ((Integer)blockstate.m_61143_((Property)JARS)).intValue()) < 4) {
            return (BlockState)((BlockState)blockstate.m_61124_((Property)JARS, (Comparable)Integer.valueOf(jars + 1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        }
        Direction facing = context.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)JARS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.rotateShape(switch ((Integer)state.m_61143_((Property)JARS)) {
            case 1 -> ONE_JAR_AABB;
            case 2 -> TWO_JAR_AABB;
            case 3 -> THREE_JAR_AABB;
            default -> FOUR_JAR_AABB;
        }, direction);
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        ArrayList rotatedShapes = new ArrayList();
        shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double[] rotated = this.rotate(minX, minZ, maxX, maxZ, direction);
            rotatedShapes.add(Shapes.m_83048_((double)rotated[0], (double)minY, (double)rotated[1], (double)rotated[2], (double)maxY, (double)rotated[3]));
        });
        return rotatedShapes.stream().reduce(Shapes::m_83110_).orElse(Shapes.m_83040_());
    }

    private double[] rotate(double minX, double minZ, double maxX, double maxZ, Direction direction) {
        switch (direction) {
            case EAST: {
                return new double[]{1.0 - maxZ, minX, 1.0 - minZ, maxX};
            }
            case SOUTH: {
                return new double[]{1.0 - maxX, 1.0 - maxZ, 1.0 - minX, 1.0 - minZ};
            }
            case WEST: {
                return new double[]{minZ, 1.0 - maxX, maxZ, 1.0 - minX};
            }
        }
        return new double[]{minX, minZ, maxX, maxZ};
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)JARS) < 4;
    }

    public boolean tryPlaceJar(Level world, BlockPos pos, Player player, ItemStack itemStack) {
        BlockState state;
        if (!world.m_8055_(pos).m_60713_((Block)this)) {
            pos = pos.m_121945_(player.m_6350_().m_122424_());
        }
        if ((state = world.m_8055_(pos)).m_60713_((Block)this)) {
            int jars = (Integer)state.m_61143_((Property)JARS);
            if (jars < 4) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)JARS, (Comparable)Integer.valueOf(jars + 1)), 3);
                itemStack.m_41774_(1);
                return true;
            }
        } else if (world.m_46859_(pos)) {
            world.m_7731_(pos, this.m_49966_(), 3);
            itemStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND && itemInHand.m_41619_()) {
            int jars = (Integer)state.m_61143_((Property)JARS);
            if (jars > 1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)JARS, (Comparable)Integer.valueOf(jars - 1)), 3);
                MasonJarBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.MASON_JAR.get()));
                return InteractionResult.SUCCESS;
            }
            if (jars == 1) {
                world.m_7471_(pos, false);
                MasonJarBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.MASON_JAR.get()));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }
}

