/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript;

import java.util.EnumSet;
import org.watermedia.shaded.mozilla.javascript.BaseFunction;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.DecompilerFlag;
import org.watermedia.shaded.mozilla.javascript.DefaultErrorReporter;
import org.watermedia.shaded.mozilla.javascript.ErrorReporter;
import org.watermedia.shaded.mozilla.javascript.IdFunctionObject;
import org.watermedia.shaded.mozilla.javascript.NativeFunction;
import org.watermedia.shaded.mozilla.javascript.Script;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.Undefined;

class NativeScript
extends BaseFunction {
    private static final long serialVersionUID = -6795101161980121700L;
    private static final Object SCRIPT_TAG = "Script";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeScript obj = new NativeScript(null);
        obj.exportAsJSClass(4, scope, sealed);
    }

    @Deprecated
    static void init(Scriptable scope, boolean sealed) {
        NativeScript.init(Context.getContext(), scope, sealed);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.script != null) {
            return this.script.exec(cx, scope);
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeErrorById("msg.script.is.not.constructor", new Object[0]);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        if (this.script instanceof NativeFunction) {
            return ((NativeFunction)((Object)this.script)).decompile(indent, flags);
        }
        return super.decompile(indent, flags);
    }

    @Override
    protected void initPrototypeId(int id2) {
        String s;
        int arity;
        switch (id2) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 4: {
                arity = 0;
                s = "exec";
                break;
            }
            case 3: {
                arity = 1;
                s = "org.watermedia.shaded.compile";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id2));
            }
        }
        this.initPrototypeMethod(SCRIPT_TAG, id2, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(SCRIPT_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id2 = f.methodId();
        switch (id2) {
            case 1: {
                String source = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
                Script script = NativeScript.compile(cx, source);
                NativeScript nscript = new NativeScript(script);
                ScriptRuntime.setObjectProtoAndParent(nscript, scope);
                return nscript;
            }
            case 2: {
                NativeScript real = NativeScript.realThis(thisObj, f);
                Script realScript = real.script;
                if (realScript == null) {
                    return "";
                }
                return cx.decompileScript(realScript, 0);
            }
            case 4: {
                throw Context.reportRuntimeErrorById("msg.cant.call.indirect", "exec");
            }
            case 3: {
                NativeScript real = NativeScript.realThis(thisObj, f);
                String source = ScriptRuntime.toString(args, 0);
                real.script = NativeScript.compile(cx, source);
                return real;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id2));
    }

    private static NativeScript realThis(Scriptable thisObj, IdFunctionObject f) {
        return NativeScript.ensureType((Object)thisObj, NativeScript.class, f);
    }

    private static Script compile(Context cx, String source) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<Script object>";
            linep[0] = 1;
        }
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        return cx.compileString(source, null, reporter, filename, linep[0], null, null);
    }

    @Override
    protected int findPrototypeId(String s) {
        int id2;
        switch (s) {
            case "constructor": {
                id2 = 1;
                break;
            }
            case "toString": {
                id2 = 2;
                break;
            }
            case "org.watermedia.shaded.compile": {
                id2 = 3;
                break;
            }
            case "exec": {
                id2 = 4;
                break;
            }
            default: {
                id2 = 0;
            }
        }
        return id2;
    }
}

